/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.io.netty.util.NetUtil;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.tcp.InetSocketAddressUtil;
import io.micrometer.shaded.reactor.netty.tcp.ProxyProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class TcpUtils {
    static final ChannelOperations.OnSetup TCP_OPS = (ch, c, msg) -> new ChannelOperations(ch, c);

    TcpUtils() {
    }

    static Bootstrap updateProxySupport(Bootstrap b, ProxyProvider proxyOptions) {
        BootstrapHandlers.updateConfiguration(b, "io.micrometer.shaded.reactor.left.proxyHandler", new ProxyProvider.DeferredProxySupport(proxyOptions));
        return BootstrapHandlers.updateResolverForProxySupport(b);
    }

    static Bootstrap removeProxySupport(Bootstrap b) {
        BootstrapHandlers.removeConfiguration(b, "io.micrometer.shaded.reactor.left.proxyHandler");
        return BootstrapHandlers.updateResolverForNoProxySupport(b);
    }

    static Bootstrap updateHost(Bootstrap b, String host) {
        return b.remoteAddress(TcpUtils._updateHost(b.config().remoteAddress(), host));
    }

    static ServerBootstrap updateHost(ServerBootstrap b, String host) {
        return (ServerBootstrap)b.localAddress(TcpUtils._updateHost(b.config().localAddress(), host));
    }

    static SocketAddress _updateHost(@Nullable SocketAddress address, String host) {
        if (!(address instanceof InetSocketAddress)) {
            return InetSocketAddressUtil.createUnresolved(host, 0);
        }
        InetSocketAddress inet = (InetSocketAddress)address;
        return InetSocketAddressUtil.createUnresolved(host, inet.getPort());
    }

    static Bootstrap updatePort(Bootstrap b, int port) {
        return b.remoteAddress(TcpUtils._updatePort(b.config().remoteAddress(), port));
    }

    static ServerBootstrap updatePort(ServerBootstrap b, int port) {
        return (ServerBootstrap)b.localAddress(TcpUtils._updatePort(b.config().localAddress(), port));
    }

    static SocketAddress _updatePort(@Nullable SocketAddress address, int port) {
        if (!(address instanceof InetSocketAddress)) {
            return InetSocketAddressUtil.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), port);
        }
        InetSocketAddress inet = (InetSocketAddress)address;
        InetAddress addr = inet.getAddress();
        String host = addr == null ? inet.getHostName() : addr.getHostAddress();
        return InetSocketAddressUtil.createUnresolved(host, port);
    }

    static SocketAddressSupplier lazyAddress(Supplier<? extends SocketAddress> supplier) {
        return new SocketAddressSupplier(supplier);
    }

    static final class SocketAddressSupplier
    extends SocketAddress
    implements Supplier<SocketAddress> {
        final Supplier<? extends SocketAddress> supplier;

        SocketAddressSupplier(Supplier<? extends SocketAddress> supplier) {
            this.supplier = Objects.requireNonNull(supplier, "Lazy address supplier must not be null");
        }

        @Override
        public SocketAddress get() {
            return this.supplier.get();
        }
    }
}

