/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.introspection;

import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.AllocationStrategy;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PoolBuilder;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;

public final class SamplingAllocationStrategy
implements AllocationStrategy {
    public final AllocationStrategy delegate;
    public final LinkedList<Throwable> gettingSamples;
    public final double gettingSamplingRate;
    final BitSet gettingSampleDecisions;
    public final LinkedList<Throwable> returningSamples;
    public final double returningSamplingRate;
    final BitSet returningSampleDecisions;
    long countGetting = 0L;
    long countReturning = 0L;

    static AllocationStrategy sizeBetweenHelper(int min, int max) {
        AllocationStrategy[] as = new AllocationStrategy[1];
        PoolBuilder.from(Mono.empty()).sizeBetween(min, max).build(config -> {
            as[0] = config.allocationStrategy();
            return null;
        });
        return as[0];
    }

    public static SamplingAllocationStrategy sizeBetweenWithSampling(int min, int max, double getPermitsSamplingRate, double returnPermitsSamplingRate) {
        return new SamplingAllocationStrategy(SamplingAllocationStrategy.sizeBetweenHelper(min, max), getPermitsSamplingRate, returnPermitsSamplingRate);
    }

    public static SamplingAllocationStrategy withSampling(AllocationStrategy delegate, double getPermitsSamplingRate, double returnPermitsSamplingRate) {
        return new SamplingAllocationStrategy(delegate, getPermitsSamplingRate, returnPermitsSamplingRate);
    }

    SamplingAllocationStrategy(AllocationStrategy delegate, double gettingSamplingRate, double returningSamplingRate) {
        if (gettingSamplingRate < 0.0 || gettingSamplingRate > 1.0) {
            throw new IllegalArgumentException("gettingSamplingRate must be between 0d and 1d (percentage)");
        }
        if (returningSamplingRate < 0.0 || returningSamplingRate > 1.0) {
            throw new IllegalArgumentException("returningSamplingRate must be between 0d and 1d (percentage)");
        }
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.gettingSamples = new LinkedList();
        this.gettingSamplingRate = gettingSamplingRate;
        int percentOfGetting = (int)(this.gettingSamplingRate * 100.0);
        this.gettingSampleDecisions = SamplingAllocationStrategy.sampleBitSet(percentOfGetting);
        this.returningSamples = new LinkedList();
        this.returningSamplingRate = returningSamplingRate;
        int percentOfReturning = (int)(this.returningSamplingRate * 100.0);
        this.returningSampleDecisions = SamplingAllocationStrategy.sampleBitSet(percentOfReturning);
    }

    static BitSet sampleBitSet(int selectedOutOf100) {
        int i;
        int size = 100;
        Random rnd = new Random();
        BitSet result = new BitSet(size);
        int[] chosen = new int[selectedOutOf100];
        for (i = 0; i < selectedOutOf100; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < selectedOutOf100) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sampleGetting(int desired) {
        boolean doSample;
        if (this.gettingSamplingRate == 0.0) {
            return;
        }
        long c = this.countGetting++;
        if (this.gettingSamplingRate == 1.0) {
            doSample = true;
        } else {
            long cMod = c % 100L;
            doSample = this.gettingSampleDecisions.get((int)cMod);
        }
        if (doSample) {
            LinkedList<Throwable> linkedList = this.gettingSamples;
            synchronized (linkedList) {
                this.gettingSamples.add(new RuntimeException("sample #" + c + ", getPermits(" + desired + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sampleReturning(int returned) {
        boolean doSample;
        if (this.returningSamplingRate == 0.0) {
            return;
        }
        long c = this.countReturning++;
        if (this.returningSamplingRate == 1.0) {
            doSample = true;
        } else {
            long cMod = c % 100L;
            doSample = this.returningSampleDecisions.get((int)cMod);
        }
        if (doSample) {
            LinkedList<Throwable> linkedList = this.gettingSamples;
            synchronized (linkedList) {
                this.returningSamples.add(new RuntimeException("sample #" + c + ", returnPermits(" + returned + ") while granted=" + this.permitGranted()));
            }
        }
    }

    @Override
    public int getPermits(int desired) {
        this.sampleGetting(desired);
        return this.delegate.getPermits(desired);
    }

    @Override
    public void returnPermits(int returned) {
        try {
            this.delegate.returnPermits(returned);
            this.sampleReturning(returned);
        }
        catch (Throwable permitError) {
            RuntimeException cause = Exceptions.multiple(this.gettingSamples);
            throw new IllegalArgumentException(String.format("Return permits failed, see cause for %d getPermits samples (%d%% of %d calls) and %d returnPermits samples (%d%% of %d calls). Reason: %s", this.gettingSamples.size(), (int)(this.gettingSamplingRate * 100.0), this.countGetting, this.returningSamples.size(), (int)(this.returningSamplingRate * 100.0), this.countReturning, permitError.getMessage()), cause);
        }
    }

    @Override
    public int estimatePermitCount() {
        return this.delegate.estimatePermitCount();
    }

    @Override
    public int permitGranted() {
        return this.delegate.permitGranted();
    }

    @Override
    public int permitMinimum() {
        return this.delegate.permitMinimum();
    }

    @Override
    public int permitMaximum() {
        return this.delegate.permitMaximum();
    }
}

