/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufInputStream;
import io.micrometer.shaded.io.netty.util.IllegalReferenceCountException;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import io.micrometer.shaded.reactor.netty.ByteBufFlux;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class ByteBufMono
extends MonoOperator<ByteBuf, ByteBuf> {
    public final Mono<ByteBuffer> asByteBuffer() {
        return this.handle((bb, sink) -> {
            try {
                sink.next(bb.nioBuffer());
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Mono<byte[]> asByteArray() {
        return this.handle((bb, sink) -> {
            try {
                byte[] bytes = new byte[bb.readableBytes()];
                bb.readBytes(bytes);
                sink.next(bytes);
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Mono<String> asString() {
        return this.asString(Charset.defaultCharset());
    }

    public final Mono<String> asString(Charset charset) {
        return this.handle((bb, sink) -> {
            try {
                sink.next(bb.readCharSequence(bb.readableBytes(), charset).toString());
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Mono<InputStream> asInputStream() {
        return this.handle((bb, sink) -> {
            try {
                sink.next(new ReleasingInputStream((ByteBuf)bb));
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final ByteBufMono retain() {
        return ByteBufMono.maybeFuse(this.doOnNext(ByteBuf::retain));
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
        this.source.subscribe(actual);
    }

    ByteBufMono(Mono<?> source) {
        super(source.map(ByteBufFlux.bytebufExtractor));
    }

    static ByteBufMono maybeFuse(Mono<?> source) {
        if (source instanceof Fuseable) {
            return new ByteBufMonoFuseable(source);
        }
        return new ByteBufMono(source);
    }

    static final class ReleasingInputStream
    extends ByteBufInputStream {
        final ByteBuf bb;
        volatile int closed;
        static final AtomicIntegerFieldUpdater<ReleasingInputStream> CLOSE = AtomicIntegerFieldUpdater.newUpdater(ReleasingInputStream.class, "closed");

        ReleasingInputStream(ByteBuf bb) {
            super(bb.retain());
            this.bb = bb;
        }

        @Override
        public void close() throws IOException {
            if (CLOSE.compareAndSet(this, 0, 1)) {
                try {
                    super.close();
                }
                finally {
                    this.bb.release();
                }
            }
        }
    }

    static final class ByteBufMonoFuseable
    extends ByteBufMono
    implements Fuseable {
        ByteBufMonoFuseable(Mono<?> source) {
            super(source);
        }
    }
}

