/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.handler.codec.http2.Http2SecurityUtil;
import io.micrometer.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.micrometer.shaded.io.netty.handler.ssl.SslContext;
import io.micrometer.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.handler.ssl.SslProvider;
import io.micrometer.shaded.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperator;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

final class HttpClientSecure
extends HttpClientOperator {
    final io.micrometer.shaded.reactor.netty.tcp.SslProvider sslProvider;
    static final Consumer<? super SslHandler> DEFAULT_HOSTNAME_VERIFICATION;
    static final io.micrometer.shaded.reactor.netty.tcp.SslProvider DEFAULT_HTTP_SSL_PROVIDER;
    static final SslContext DEFAULT_CLIENT_HTTP2_CONTEXT;
    static final Consumer<SslProvider.SslContextSpec> SSL_DEFAULT_SPEC_HTTP2;

    static HttpClient secure(HttpClient client, Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        SslProvider.SslContextSpec builder = io.micrometer.shaded.reactor.netty.tcp.SslProvider.builder();
        sslProviderBuilder.accept(builder);
        return new HttpClientSecure(client, ((SslProvider.Builder)((Object)builder)).build());
    }

    HttpClientSecure(HttpClient client, @Nullable io.micrometer.shaded.reactor.netty.tcp.SslProvider sslProvider) {
        super(client);
        this.sslProvider = sslProvider;
    }

    @Override
    protected TcpClient tcpConfiguration() {
        if (this.sslProvider == null) {
            return this.source.tcpConfiguration().secure(DEFAULT_HTTP_SSL_PROVIDER);
        }
        return this.source.tcpConfiguration().secure(io.micrometer.shaded.reactor.netty.tcp.SslProvider.addHandlerConfigurator(this.sslProvider, DEFAULT_HOSTNAME_VERIFICATION));
    }

    static {
        SslContext sslCtx;
        DEFAULT_HOSTNAME_VERIFICATION = handler -> {
            SSLEngine sslEngine = handler.engine();
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        };
        DEFAULT_HTTP_SSL_PROVIDER = io.micrometer.shaded.reactor.netty.tcp.SslProvider.addHandlerConfigurator(io.micrometer.shaded.reactor.netty.tcp.SslProvider.defaultClientProvider(), DEFAULT_HOSTNAME_VERIFICATION);
        try {
            SslProvider provider = SslProvider.isAlpnSupported(SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
            sslCtx = SslContextBuilder.forClient().sslProvider(provider).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, "h2", "http/1.1")).build();
        }
        catch (Exception e) {
            sslCtx = null;
        }
        DEFAULT_CLIENT_HTTP2_CONTEXT = sslCtx;
        SSL_DEFAULT_SPEC_HTTP2 = sslProviderBuilder -> sslProviderBuilder.sslContext(DEFAULT_CLIENT_HTTP2_CONTEXT);
    }
}

