/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.transport;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocatorMetric;
import io.micrometer.shaded.io.netty.buffer.PooledByteBufAllocatorMetric;
import io.micrometer.shaded.io.netty.util.internal.PlatformDependent;
import io.micrometer.shaded.reactor.netty.Metrics;
import java.util.concurrent.ConcurrentMap;

final class ByteBufAllocatorMetrics {
    static final ByteBufAllocatorMetrics INSTANCE = new ByteBufAllocatorMetrics();
    final ConcurrentMap<String, ByteBufAllocatorMetric> cache = PlatformDependent.newConcurrentHashMap();

    private ByteBufAllocatorMetrics() {
    }

    void registerMetrics(String allocType, ByteBufAllocatorMetric metrics) {
        this.cache.computeIfAbsent(metrics.hashCode() + "", key -> {
            String[] tags = new String[]{"id", key, "type", allocType};
            Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.used.heap.memory", (Object)metrics, ByteBufAllocatorMetric::usedHeapMemory).description("The number of the bytes of the heap memory.").tags(tags).register(Metrics.REGISTRY);
            Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.used.direct.memory", (Object)metrics, ByteBufAllocatorMetric::usedDirectMemory).description("The number of the bytes of the direct memory.").tags(tags).register(Metrics.REGISTRY);
            if (metrics instanceof PooledByteBufAllocatorMetric) {
                PooledByteBufAllocatorMetric pooledMetrics = (PooledByteBufAllocatorMetric)metrics;
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.heap.arenas", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numHeapArenas).description("The number of heap arenas.").tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.direct.arenas", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numDirectArenas).description("The number of direct arenas.").tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.threadlocal.caches", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numThreadLocalCaches).description("The number of thread local caches.").tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.small.cache.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::smallCacheSize).description("The size of the small cache.").tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.normal.cache.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::normalCacheSize).description("The size of the normal cache.").tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.chunk.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::chunkSize).description("The chunk size for an arena.").tags(tags).register(Metrics.REGISTRY);
            }
            return metrics;
        });
    }
}

