/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelInitializer;
import io.micrometer.shaded.io.netty.resolver.AddressResolverGroup;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Disposables;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.Sinks;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.FutureMono;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PooledRef;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.resources.PooledConnectionProvider;
import io.micrometer.shaded.reactor.netty.transport.TransportConfig;
import io.micrometer.shaded.reactor.netty.transport.TransportConnector;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import io.micrometer.shaded.reactor.util.context.Context;
import java.io.IOException;
import java.net.SocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.Function;

final class DefaultPooledConnectionProvider
extends PooledConnectionProvider<PooledConnection> {
    final Map<SocketAddress, PooledConnectionProvider.PoolFactory<PooledConnection>> poolFactoryPerRemoteHost = new HashMap<SocketAddress, PooledConnectionProvider.PoolFactory<PooledConnection>>();
    final Map<SocketAddress, Integer> maxConnections = new HashMap<SocketAddress, Integer>();
    static final Logger log = Loggers.getLogger(DefaultPooledConnectionProvider.class);
    static final AttributeKey<ConnectionObserver> OWNER = AttributeKey.valueOf("connectionOwner");

    DefaultPooledConnectionProvider(ConnectionProvider.Builder builder) {
        this(builder, null);
    }

    DefaultPooledConnectionProvider(ConnectionProvider.Builder builder, @Nullable Clock clock) {
        super(builder, clock);
        for (Map.Entry<SocketAddress, ConnectionProvider.ConnectionPoolSpec<?>> entry : builder.confPerRemoteHost.entrySet()) {
            this.poolFactoryPerRemoteHost.put(entry.getKey(), new PooledConnectionProvider.PoolFactory(entry.getValue(), builder.disposeTimeout));
            this.maxConnections.put(entry.getKey(), entry.getValue().maxConnections);
        }
    }

    @Override
    public Map<SocketAddress, Integer> maxConnectionsPerHost() {
        return this.maxConnections;
    }

    @Override
    protected CoreSubscriber<PooledRef<PooledConnection>> createDisposableAcquire(TransportConfig config, ConnectionObserver connectionObserver, long pendingAcquireTimeout, InstrumentedPool<PooledConnection> pool, MonoSink<Connection> sink) {
        return new DisposableAcquire(connectionObserver, config.channelOperationsProvider(), pendingAcquireTimeout, pool, sink);
    }

    @Override
    protected InstrumentedPool<PooledConnection> createPool(TransportConfig config, PooledConnectionProvider.PoolFactory<PooledConnection> poolFactory, SocketAddress remoteAddress, AddressResolverGroup<?> resolverGroup) {
        return new PooledConnectionAllocator((TransportConfig)config, poolFactory, (SocketAddress)remoteAddress, resolverGroup).pool;
    }

    @Override
    protected PooledConnectionProvider.PoolFactory<PooledConnection> poolFactory(SocketAddress remoteAddress) {
        return this.poolFactoryPerRemoteHost.getOrDefault(remoteAddress, this.defaultPoolFactory);
    }

    static final class PooledConnectionAllocator {
        final TransportConfig config;
        final InstrumentedPool<PooledConnection> pool;
        final SocketAddress remoteAddress;
        final AddressResolverGroup<?> resolver;
        static final BiPredicate<PooledConnection, PooledRefMetadata> DEFAULT_EVICTION_PREDICATE = (pooledConnection, metadata) -> !pooledConnection.channel.isActive() || !pooledConnection.isPersistent();
        static final Function<PooledConnection, Publisher<Void>> DEFAULT_DESTROY_HANDLER = pooledConnection -> {
            if (!pooledConnection.channel.isActive()) {
                return Mono.empty();
            }
            return FutureMono.from(pooledConnection.channel.close());
        };

        PooledConnectionAllocator(TransportConfig config, PooledConnectionProvider.PoolFactory<PooledConnection> provider, SocketAddress remoteAddress, AddressResolverGroup<?> resolver) {
            this.config = config;
            this.remoteAddress = remoteAddress;
            this.resolver = resolver;
            this.pool = provider.newPool(this.connectChannel(), null, DEFAULT_DESTROY_HANDLER, DEFAULT_EVICTION_PREDICATE);
        }

        Publisher<PooledConnection> connectChannel() {
            return Mono.create(sink -> {
                PooledConnectionInitializer initializer = new PooledConnectionInitializer((MonoSink<PooledConnection>)sink);
                TransportConnector.connect(this.config, this.remoteAddress, this.resolver, initializer).subscribe(initializer);
            });
        }

        final class PooledConnectionInitializer
        extends ChannelInitializer<Channel>
        implements CoreSubscriber<Channel> {
            final MonoSink<PooledConnection> sink;
            PooledConnection pooledConnection;

            PooledConnectionInitializer(MonoSink<PooledConnection> sink) {
                this.sink = sink;
            }

            @Override
            protected void initChannel(Channel ch) {
                PooledConnection pooledConnection;
                if (log.isDebugEnabled()) {
                    PooledConnectionProvider.logPoolState(ch, PooledConnectionAllocator.this.pool, "Created a new pooled channel");
                }
                this.pooledConnection = pooledConnection = new PooledConnection(ch, PooledConnectionAllocator.this.pool);
                ch.attr(OWNER).compareAndSet(null, new PendingConnectionObserver(this.sink.currentContext()));
                ch.pipeline().remove(this);
                ch.pipeline().addFirst(PooledConnectionAllocator.this.config.channelInitializer(pooledConnection, PooledConnectionAllocator.this.remoteAddress, false));
                pooledConnection.bind();
            }

            @Override
            public void onComplete() {
            }

            @Override
            public void onError(Throwable t) {
                this.sink.error(t);
            }

            @Override
            public void onNext(Channel channel) {
                this.sink.success(this.pooledConnection);
            }

            @Override
            public void onSubscribe(Subscription s) {
                s.request(Long.MAX_VALUE);
            }
        }
    }

    static final class PooledConnection
    extends AtomicLong
    implements Connection,
    ConnectionObserver {
        final Channel channel;
        final Sinks.Empty<Void> onTerminate;
        final InstrumentedPool<PooledConnection> pool;
        PooledRef<PooledConnection> pooledRef;

        PooledConnection(Channel channel, InstrumentedPool<PooledConnection> pool) {
            this.channel = channel;
            this.onTerminate = Sinks.unsafe().empty();
            this.pool = pool;
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        @Override
        public Context currentContext() {
            return this.owner().currentContext();
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), connection, newState);
            }
            if (newState == ConnectionObserver.State.DISCONNECTING) {
                if (!this.isPersistent() && this.channel.isActive()) {
                    this.channel.close();
                    this.owner().onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
                    return;
                }
                if (!this.channel.isActive()) {
                    this.owner().onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "Releasing channel"));
                }
                ConnectionObserver obs = this.channel.attr(OWNER).getAndSet(ConnectionObserver.emptyListener());
                if (this.pooledRef == null) {
                    return;
                }
                this.pooledRef.release().subscribe(null, t -> {
                    if (log.isDebugEnabled()) {
                        PooledConnectionProvider.logPoolState(this.pooledRef.poolable().channel, this.pool, "Failed cleaning the channel from pool", t);
                    }
                    this.onTerminate.tryEmitEmpty();
                    obs.onStateChange(connection, ConnectionObserver.State.RELEASED);
                }, () -> {
                    if (log.isDebugEnabled()) {
                        PooledConnectionProvider.logPoolState(this.pooledRef.poolable().channel, this.pool, "Channel cleaned");
                    }
                    this.onTerminate.tryEmitEmpty();
                    obs.onStateChange(connection, ConnectionObserver.State.RELEASED);
                });
                return;
            }
            this.owner().onStateChange(connection, newState);
        }

        @Override
        public Mono<Void> onTerminate() {
            return this.onTerminate.asMono().or(this.onDispose());
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.owner().onUncaughtException(connection, error);
        }

        @Override
        public String toString() {
            return "PooledConnection{channel=" + this.channel + '}';
        }

        ConnectionObserver owner() {
            ConnectionObserver obs;
            do {
                if ((obs = this.channel.attr(OWNER).get()) != null) {
                    return obs;
                }
                obs = new PendingConnectionObserver();
            } while (!this.channel.attr(OWNER).compareAndSet(null, obs));
            return obs;
        }
    }

    static final class PendingConnectionObserver
    implements ConnectionObserver {
        final Queue<Pending> pendingQueue = Queues.unbounded(4).get();
        final Context context;

        public PendingConnectionObserver() {
            this(Context.empty());
        }

        public PendingConnectionObserver(Context context) {
            this.context = context;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.pendingQueue.add(new Pending(connection, null, newState));
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.pendingQueue.add(new Pending(connection, error, null));
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        static class Pending {
            final Connection connection;
            final Throwable error;
            final ConnectionObserver.State state;

            Pending(Connection connection, @Nullable Throwable error, @Nullable ConnectionObserver.State state) {
                this.connection = connection;
                this.error = error;
                this.state = state;
            }
        }
    }

    static final class DisposableAcquire
    implements ConnectionObserver,
    Runnable,
    CoreSubscriber<PooledRef<PooledConnection>>,
    Disposable {
        final Disposable.Composite cancellations;
        final ConnectionObserver obs;
        final ChannelOperations.OnSetup opsFactory;
        final long pendingAcquireTimeout;
        final InstrumentedPool<PooledConnection> pool;
        final boolean retried;
        final MonoSink<Connection> sink;
        PooledRef<PooledConnection> pooledRef;
        Subscription subscription;

        DisposableAcquire(ConnectionObserver obs, ChannelOperations.OnSetup opsFactory, long pendingAcquireTimeout, InstrumentedPool<PooledConnection> pool, MonoSink<Connection> sink) {
            this.cancellations = Disposables.composite();
            this.obs = obs;
            this.opsFactory = opsFactory;
            this.pendingAcquireTimeout = pendingAcquireTimeout;
            this.pool = pool;
            this.retried = false;
            this.sink = sink;
        }

        DisposableAcquire(DisposableAcquire parent) {
            this.cancellations = parent.cancellations;
            this.obs = parent.obs;
            this.opsFactory = parent.opsFactory;
            this.pendingAcquireTimeout = parent.pendingAcquireTimeout;
            this.pool = parent.pool;
            this.retried = true;
            this.sink = parent.sink;
        }

        @Override
        public Context currentContext() {
            return this.sink.currentContext();
        }

        @Override
        public void dispose() {
            this.subscription.cancel();
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable throwable) {
            this.sink.error(throwable);
        }

        @Override
        public void onNext(PooledRef<PooledConnection> value) {
            this.pooledRef = value;
            PooledConnection pooledConnection = value.poolable();
            pooledConnection.pooledRef = this.pooledRef;
            Channel c = pooledConnection.channel;
            if (c.eventLoop().inEventLoop()) {
                this.run();
            } else {
                c.eventLoop().execute(this);
            }
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success(connection);
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.cancellations.add(this);
                if (!this.retried) {
                    this.sink.onCancel(this.cancellations);
                }
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.sink.error(error);
            this.obs.onUncaughtException(connection, error);
        }

        @Override
        public void run() {
            PooledConnection pooledConnection = this.pooledRef.poolable();
            Channel c = pooledConnection.channel;
            if (!c.isActive()) {
                this.pooledRef.invalidate().subscribe(null, null, () -> {
                    if (log.isDebugEnabled()) {
                        PooledConnectionProvider.logPoolState(c, this.pool, "Channel closed");
                    }
                });
                if (!this.retried) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(c, "Immediately aborted pooled channel, re-acquiring new channel"));
                    }
                    this.pool.acquire(Duration.ofMillis(this.pendingAcquireTimeout)).subscribe(new DisposableAcquire(this));
                } else {
                    this.sink.error(new IOException("Error while acquiring from " + this.pool));
                }
                return;
            }
            ConnectionObserver current = c.attr(OWNER).getAndSet(this);
            if (current instanceof PendingConnectionObserver) {
                PendingConnectionObserver.Pending p;
                PendingConnectionObserver pending = (PendingConnectionObserver)current;
                current = null;
                this.registerClose(this.pooledRef, this.pool);
                while ((p = pending.pendingQueue.poll()) != null) {
                    if (p.error != null) {
                        this.onUncaughtException(p.connection, p.error);
                        continue;
                    }
                    if (p.state == null) continue;
                    this.onStateChange(p.connection, p.state);
                }
            } else if (current == null) {
                this.registerClose(this.pooledRef, this.pool);
            }
            if (current != null) {
                if (log.isDebugEnabled()) {
                    PooledConnectionProvider.logPoolState(c, this.pool, "Channel acquired");
                }
                this.obs.onStateChange(pooledConnection, ConnectionObserver.State.ACQUIRED);
                ChannelOperations<?, ?> ops = this.opsFactory.create(pooledConnection, pooledConnection, null);
                if (ops != null) {
                    if (c.pipeline().get("io.micrometer.shaded.reactor.left.h2MultiplexHandler") == null) {
                        ops.bind();
                        this.sink.success(ops);
                        this.obs.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
                    } else {
                        this.sink.success(ops);
                        this.obs.onStateChange(pooledConnection, ConnectionObserver.State.CONFIGURED);
                    }
                } else {
                    this.sink.success(pooledConnection);
                }
                return;
            }
            if (log.isDebugEnabled()) {
                PooledConnectionProvider.logPoolState(c, this.pool, "Channel connected");
            }
            if (this.opsFactory == ChannelOperations.OnSetup.empty()) {
                this.sink.success(Connection.from(c));
            }
        }

        void registerClose(PooledRef<PooledConnection> pooledRef, InstrumentedPool<PooledConnection> pool) {
            Channel channel = pooledRef.poolable().channel;
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Registering pool release on close event for channel"));
            }
            channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)ff -> {
                ConnectionObserver owner = channel.attr(OWNER).get();
                if (owner instanceof DisposableAcquire) {
                    ((DisposableAcquire)owner).pooledRef.invalidate().subscribe(null, null, () -> {
                        if (log.isDebugEnabled()) {
                            PooledConnectionProvider.logPoolState(channel, pool, "Channel closed");
                        }
                    });
                }
            }));
        }
    }
}

