/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.socket.DatagramPacket;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;

public abstract class AbstractChannelMetricsHandler
extends ChannelDuplexHandler {
    final SocketAddress remoteAddress;
    final boolean onServer;

    protected AbstractChannelMetricsHandler(@Nullable SocketAddress remoteAddress, boolean onServer) {
        this.remoteAddress = remoteAddress;
        this.onServer = onServer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
        ctx.fireChannelInactive();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        if (!this.onServer) {
            ctx.pipeline().addAfter("io.micrometer.shaded.reactor.left.channelMetricsHandler", "io.micrometer.shaded.reactor.left.connectMetricsHandler", this.connectMetricsHandler());
        }
        ctx.fireChannelRegistered();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        DatagramPacket p;
        ByteBuf buffer;
        if (msg instanceof ByteBuf) {
            ByteBuf buffer2 = (ByteBuf)msg;
            if (buffer2.readableBytes() > 0) {
                this.recordRead(ctx, this.remoteAddress, buffer2.readableBytes());
            }
        } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
            this.recordRead(ctx, this.remoteAddress != null ? this.remoteAddress : p.sender(), buffer.readableBytes());
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        DatagramPacket p;
        ByteBuf buffer;
        if (msg instanceof ByteBuf) {
            ByteBuf buffer2 = (ByteBuf)msg;
            if (buffer2.readableBytes() > 0) {
                this.recordWrite(ctx, this.remoteAddress, buffer2.readableBytes());
            }
        } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
            this.recordWrite(ctx, this.remoteAddress != null ? this.remoteAddress : p.recipient(), buffer.readableBytes());
        }
        ctx.write(msg, promise);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.recordException(ctx, this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress());
        ctx.fireExceptionCaught(cause);
    }

    public abstract ChannelHandler connectMetricsHandler();

    public abstract ChannelMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx, SocketAddress address) {
        this.recorder().incrementErrorsCount(address);
    }

    protected void recordRead(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        this.recorder().recordDataReceived(address, bytes);
    }

    protected void recordWrite(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        this.recorder().recordDataSent(address, bytes);
    }
}

