/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.transport;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocatorMetric;
import io.micrometer.shaded.io.netty.buffer.PooledByteBufAllocatorMetric;
import io.micrometer.shaded.reactor.netty.Metrics;
import io.micrometer.shaded.reactor.netty.internal.util.MapUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class ByteBufAllocatorMetrics {
    static final String CHUNK_SIZE_DESCRIPTION = "The chunk size for an arena.";
    static final String DIRECT_ARENAS_DESCRIPTION = "The number of direct arenas.";
    static final String HEAP_ARENAS_DESCRIPTION = "The number of heap arenas.";
    static final String NORMAL_CACHE_SIZE_DESCRIPTION = "The size of the normal cache.";
    static final String SMALL_CACHE_SIZE_DESCRIPTION = "The size of the small cache.";
    static final String THREAD_LOCAL_CACHES_DESCRIPTION = "The number of thread local caches.";
    static final String USED_DIRECT_MEMORY_DESCRIPTION = "The number of the bytes of the direct memory.";
    static final String USED_HEAP_MEMORY_DESCRIPTION = "The number of the bytes of the heap memory.";
    static final ByteBufAllocatorMetrics INSTANCE = new ByteBufAllocatorMetrics();
    final ConcurrentMap<String, ByteBufAllocatorMetric> cache = new ConcurrentHashMap<String, ByteBufAllocatorMetric>();

    private ByteBufAllocatorMetrics() {
    }

    void registerMetrics(String allocType, ByteBufAllocatorMetric metrics) {
        MapUtils.computeIfAbsent(this.cache, metrics.hashCode() + "", key -> {
            String[] tags = new String[]{"id", key, "type", allocType};
            Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.used.heap.memory", (Object)metrics, ByteBufAllocatorMetric::usedHeapMemory).description(USED_HEAP_MEMORY_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
            Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.used.direct.memory", (Object)metrics, ByteBufAllocatorMetric::usedDirectMemory).description(USED_DIRECT_MEMORY_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
            if (metrics instanceof PooledByteBufAllocatorMetric) {
                PooledByteBufAllocatorMetric pooledMetrics = (PooledByteBufAllocatorMetric)metrics;
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.heap.arenas", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numHeapArenas).description(HEAP_ARENAS_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.direct.arenas", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numDirectArenas).description(DIRECT_ARENAS_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.threadlocal.caches", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numThreadLocalCaches).description(THREAD_LOCAL_CACHES_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.small.cache.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::smallCacheSize).description(SMALL_CACHE_SIZE_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.normal.cache.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::normalCacheSize).description(NORMAL_CACHE_SIZE_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"io.micrometer.shaded.reactor.netty.bytebuf.allocator.chunk.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::chunkSize).description(CHUNK_SIZE_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
            }
            return metrics;
        });
    }
}

