/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Metrics {
    public static final MeterRegistry REGISTRY = io.micrometer.core.instrument.Metrics.globalRegistry;
    public static final String HTTP_SERVER_PREFIX = "io.micrometer.shaded.reactor.netty.http.server";
    public static final String HTTP_CLIENT_PREFIX = "io.micrometer.shaded.reactor.netty.http.client";
    public static final String TCP_SERVER_PREFIX = "io.micrometer.shaded.reactor.netty.tcp.server";
    public static final String TCP_CLIENT_PREFIX = "io.micrometer.shaded.reactor.netty.tcp.client";
    public static final String UDP_SERVER_PREFIX = "io.micrometer.shaded.reactor.netty.udp.server";
    public static final String UDP_CLIENT_PREFIX = "io.micrometer.shaded.reactor.netty.udp.client";
    public static final String EVENT_LOOP_PREFIX = "io.micrometer.shaded.reactor.netty.eventloop";
    public static final String CONNECTION_PROVIDER_PREFIX = "io.micrometer.shaded.reactor.netty.connection.provider";
    public static final String BYTE_BUF_ALLOCATOR_PREFIX = "io.micrometer.shaded.reactor.netty.bytebuf.allocator";
    public static final String DATA_RECEIVED = ".data.received";
    public static final String DATA_SENT = ".data.sent";
    public static final String ERRORS = ".errors";
    public static final String TLS_HANDSHAKE_TIME = ".tls.handshake.time";
    public static final String CONNECT_TIME = ".connect.time";
    public static final String DATA_RECEIVED_TIME = ".data.received.time";
    public static final String DATA_SENT_TIME = ".data.sent.time";
    public static final String RESPONSE_TIME = ".response.time";
    public static final String CONNECTIONS_TOTAL = ".connections.total";
    public static final String CONNECTIONS_ACTIVE = ".connections.active";
    public static final String ADDRESS_RESOLVER = ".address.resolver";
    public static final String TOTAL_CONNECTIONS = ".total.connections";
    public static final String ACTIVE_CONNECTIONS = ".active.connections";
    public static final String MAX_CONNECTIONS = ".max.connections";
    public static final String IDLE_CONNECTIONS = ".idle.connections";
    public static final String PENDING_CONNECTIONS = ".pending.connections";
    public static final String MAX_PENDING_CONNECTIONS = ".max.pending.connections";
    public static final String ACTIVE_STREAMS = ".active.streams";
    public static final String PENDING_STREAMS = ".pending.streams";
    public static final String USED_HEAP_MEMORY = ".used.heap.memory";
    public static final String USED_DIRECT_MEMORY = ".used.direct.memory";
    public static final String ACTIVE_HEAP_MEMORY = ".active.heap.memory";
    public static final String ACTIVE_DIRECT_MEMORY = ".active.direct.memory";
    public static final String HEAP_ARENAS = ".heap.arenas";
    public static final String DIRECT_ARENAS = ".direct.arenas";
    public static final String THREAD_LOCAL_CACHES = ".threadlocal.caches";
    public static final String SMALL_CACHE_SIZE = ".small.cache.size";
    public static final String NORMAL_CACHE_SIZE = ".normal.cache.size";
    public static final String CHUNK_SIZE = ".chunk.size";
    public static final String PENDING_TASKS = ".pending.tasks";
    public static final String LOCAL_ADDRESS = "local.address";
    public static final String REMOTE_ADDRESS = "remote.address";
    public static final String URI = "uri";
    public static final String STATUS = "status";
    public static final String METHOD = "method";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    @Nullable
    public static String formatSocketAddress(@Nullable SocketAddress socketAddress) {
        if (socketAddress != null) {
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)socketAddress;
                return address.getHostString() + ":" + address.getPort();
            }
            return socketAddress.toString();
        }
        return null;
    }
}

