/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.socket.DatagramPacket;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;

public abstract class AbstractChannelMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractChannelMetricsHandler.class);
    final SocketAddress remoteAddress;
    final boolean onServer;

    protected AbstractChannelMetricsHandler(@Nullable SocketAddress remoteAddress, boolean onServer) {
        this.remoteAddress = remoteAddress;
        this.onServer = onServer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        if (this.onServer) {
            try {
                this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
            }
            catch (RuntimeException e) {
                log.warn("Exception caught while recording metrics.", e);
            }
        }
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.onServer) {
            try {
                this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
            }
            catch (RuntimeException e) {
                log.warn("Exception caught while recording metrics.", e);
            }
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        if (!this.onServer) {
            ctx.pipeline().addAfter("io.micrometer.shaded.reactor.left.channelMetricsHandler", "io.micrometer.shaded.reactor.left.connectMetricsHandler", this.connectMetricsHandler());
        }
        if (ctx.pipeline().get("io.micrometer.shaded.reactor.left.sslHandler") != null) {
            ctx.pipeline().addBefore("io.micrometer.shaded.reactor.left.sslHandler", "io.micrometer.shaded.reactor.left.tlsMetricsHandler", this.tlsMetricsHandler());
        }
        ctx.fireChannelRegistered();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            DatagramPacket p;
            ByteBuf buffer;
            if (msg instanceof ByteBuf) {
                ByteBuf buffer2 = (ByteBuf)msg;
                if (buffer2.readableBytes() > 0) {
                    this.recordRead(ctx, this.remoteAddress, buffer2.readableBytes());
                }
            } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
                this.recordRead(ctx, this.remoteAddress != null ? this.remoteAddress : p.sender(), buffer.readableBytes());
            }
        }
        catch (RuntimeException e) {
            log.warn("Exception caught while recording metrics.", e);
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            DatagramPacket p;
            ByteBuf buffer;
            if (msg instanceof ByteBuf) {
                ByteBuf buffer2 = (ByteBuf)msg;
                if (buffer2.readableBytes() > 0) {
                    this.recordWrite(ctx, this.remoteAddress, buffer2.readableBytes());
                }
            } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
                this.recordWrite(ctx, this.remoteAddress != null ? this.remoteAddress : p.recipient(), buffer.readableBytes());
            }
        }
        catch (RuntimeException e) {
            log.warn("Exception caught while recording metrics.", e);
        }
        ctx.write(msg, promise);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            this.recordException(ctx, this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress());
        }
        catch (RuntimeException e) {
            log.warn("Exception caught while recording metrics.", e);
        }
        ctx.fireExceptionCaught(cause);
    }

    public abstract ChannelHandler connectMetricsHandler();

    public abstract ChannelHandler tlsMetricsHandler();

    public abstract ChannelMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx, SocketAddress address) {
        this.recorder().incrementErrorsCount(address);
    }

    protected void recordRead(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        this.recorder().recordDataReceived(address, bytes);
    }

    protected void recordWrite(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        this.recorder().recordDataSent(address, bytes);
    }
}

