/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.transport;

import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.io.netty.handler.logging.LogLevel;
import io.micrometer.shaded.io.netty.resolver.HostsFileEntriesResolver;
import io.micrometer.shaded.io.netty.resolver.ResolvedAddressTypes;
import io.micrometer.shaded.io.netty.resolver.dns.DnsAddressResolverGroup;
import io.micrometer.shaded.io.netty.resolver.dns.DnsNameResolverBuilder;
import io.micrometer.shaded.io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.micrometer.shaded.io.netty.resolver.dns.LoggingDnsQueryLifeCycleObserverFactory;
import io.micrometer.shaded.io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class NameResolverProvider {
    final Duration cacheMaxTimeToLive;
    final Duration cacheMinTimeToLive;
    final Duration cacheNegativeTimeToLive;
    final boolean completeOncePreferredResolved;
    final boolean disableRecursionDesired;
    final boolean disableOptionalRecord;
    final HostsFileEntriesResolver hostsFileEntriesResolver;
    final DnsQueryLifecycleObserverFactory loggingFactory;
    final LoopResources loopResources;
    final int maxPayloadSize;
    final int maxQueriesPerResolve;
    final int ndots;
    final boolean preferNative;
    final Duration queryTimeout;
    final ResolvedAddressTypes resolvedAddressTypes;
    final Supplier<? extends SocketAddress> bindAddressSupplier;
    final boolean roundRobinSelection;
    final Iterable<String> searchDomains;

    public static NameResolverSpec builder() {
        return new Build();
    }

    public Duration cacheMaxTimeToLive() {
        return this.cacheMaxTimeToLive;
    }

    public Duration cacheMinTimeToLive() {
        return this.cacheMinTimeToLive;
    }

    public Duration cacheNegativeTimeToLive() {
        return this.cacheNegativeTimeToLive;
    }

    @Nullable
    public HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    public boolean isCompleteOncePreferredResolved() {
        return this.completeOncePreferredResolved;
    }

    public boolean isDisableOptionalRecord() {
        return this.disableOptionalRecord;
    }

    public boolean isDisableRecursionDesired() {
        return this.disableRecursionDesired;
    }

    public boolean isPreferNative() {
        return this.preferNative;
    }

    public boolean isRoundRobinSelection() {
        return this.roundRobinSelection;
    }

    @Nullable
    public LoopResources loopResources() {
        return this.loopResources;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public int ndots() {
        return this.ndots;
    }

    public Duration queryTimeout() {
        return this.queryTimeout;
    }

    @Nullable
    public ResolvedAddressTypes resolvedAddressTypes() {
        return this.resolvedAddressTypes;
    }

    @Nullable
    public Supplier<? extends SocketAddress> bindAddressSupplier() {
        return this.bindAddressSupplier;
    }

    @Nullable
    public Iterable<String> searchDomains() {
        return this.searchDomains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NameResolverProvider)) {
            return false;
        }
        NameResolverProvider that = (NameResolverProvider)o;
        return this.completeOncePreferredResolved == that.completeOncePreferredResolved && this.disableRecursionDesired == that.disableRecursionDesired && this.disableOptionalRecord == that.disableOptionalRecord && this.maxPayloadSize == that.maxPayloadSize && this.maxQueriesPerResolve == that.maxQueriesPerResolve && this.ndots == that.ndots && this.preferNative == that.preferNative && this.roundRobinSelection == that.roundRobinSelection && Objects.equals(this.loggingFactory, that.loggingFactory) && this.cacheMaxTimeToLive.equals(that.cacheMaxTimeToLive) && this.cacheMinTimeToLive.equals(that.cacheMinTimeToLive) && this.cacheNegativeTimeToLive.equals(that.cacheNegativeTimeToLive) && Objects.equals(this.loopResources, that.loopResources) && this.queryTimeout.equals(that.queryTimeout) && this.resolvedAddressTypes == that.resolvedAddressTypes && Objects.equals(this.bindAddressSupplier, that.bindAddressSupplier) && Objects.equals(this.searchDomains, that.searchDomains);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cacheMaxTimeToLive, this.cacheMinTimeToLive, this.cacheNegativeTimeToLive, this.completeOncePreferredResolved, this.disableRecursionDesired, this.disableOptionalRecord, this.loggingFactory, this.loopResources, this.maxPayloadSize, this.maxQueriesPerResolve, this.ndots, this.preferNative, this.queryTimeout, this.resolvedAddressTypes, this.bindAddressSupplier, this.roundRobinSelection, this.searchDomains});
    }

    public DnsAddressResolverGroup newNameResolverGroup(LoopResources defaultLoopResources, boolean defaultPreferNative) {
        EventLoopGroup group;
        LoopResources loop;
        Objects.requireNonNull(defaultLoopResources, "defaultLoopResources");
        if (this.loopResources == null) {
            loop = defaultLoopResources;
            group = loop.onClient(defaultPreferNative);
        } else {
            loop = this.loopResources;
            group = loop.onClient(this.preferNative);
        }
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder().ttl(Math.toIntExact(this.cacheMinTimeToLive.getSeconds()), Math.toIntExact(this.cacheMaxTimeToLive.getSeconds())).negativeTtl(Math.toIntExact(this.cacheNegativeTimeToLive.getSeconds())).completeOncePreferredResolved(this.completeOncePreferredResolved).optResourceEnabled(!this.disableOptionalRecord).recursionDesired(!this.disableRecursionDesired).maxPayloadSize(this.maxPayloadSize).maxQueriesPerResolve(this.maxQueriesPerResolve).ndots(this.ndots).queryTimeoutMillis(this.queryTimeout.toMillis()).eventLoop(group.next()).channelFactory(() -> loop.onChannel(DatagramChannel.class, group)).socketChannelFactory(() -> loop.onChannel(SocketChannel.class, group));
        if (this.hostsFileEntriesResolver != null) {
            builder.hostsFileEntriesResolver(this.hostsFileEntriesResolver);
        }
        if (this.loggingFactory != null) {
            builder.dnsQueryLifecycleObserverFactory(this.loggingFactory);
        }
        if (this.resolvedAddressTypes != null) {
            builder.resolvedAddressTypes(this.resolvedAddressTypes);
        }
        if (this.bindAddressSupplier != null) {
            builder.localAddress(this.bindAddressSupplier.get());
        }
        if (this.searchDomains != null) {
            builder.searchDomains(this.searchDomains);
        }
        return this.roundRobinSelection ? new RoundRobinDnsAddressResolverGroup(builder) : new DnsAddressResolverGroup(builder);
    }

    NameResolverProvider(Build build) {
        this.cacheMaxTimeToLive = build.cacheMaxTimeToLive;
        this.cacheMinTimeToLive = build.cacheMinTimeToLive;
        this.cacheNegativeTimeToLive = build.cacheNegativeTimeToLive;
        this.completeOncePreferredResolved = build.completeOncePreferredResolved;
        this.disableOptionalRecord = build.disableOptionalRecord;
        this.disableRecursionDesired = build.disableRecursionDesired;
        this.hostsFileEntriesResolver = build.hostsFileEntriesResolver;
        this.loggingFactory = build.loggingFactory;
        this.loopResources = build.loopResources;
        this.maxPayloadSize = build.maxPayloadSize;
        this.maxQueriesPerResolve = build.maxQueriesPerResolve;
        this.ndots = build.ndots;
        this.preferNative = build.preferNative;
        this.queryTimeout = build.queryTimeout;
        this.resolvedAddressTypes = build.resolvedAddressTypes;
        this.bindAddressSupplier = build.bindAddressSupplier;
        this.roundRobinSelection = build.roundRobinSelection;
        this.searchDomains = build.searchDomains;
    }

    static final class Build
    implements NameResolverSpec {
        static final Duration DEFAULT_CACHE_MAX_TIME_TO_LIVE = Duration.ofSeconds(Integer.MAX_VALUE);
        static final Duration DEFAULT_CACHE_MIN_TIME_TO_LIVE = Duration.ofSeconds(0L);
        static final Duration DEFAULT_CACHE_NEGATIVE_TIME_TO_LIVE = Duration.ofSeconds(0L);
        static final boolean DEFAULT_COMPLETE_ONCE_PREFERRED_RESOLVED = true;
        static final int DEFAULT_MAX_PAYLOAD_SIZE = 4096;
        static final int DEFAULT_MAX_QUERIES_PER_RESOLVE = 16;
        static final int DEFAULT_NDOTS = -1;
        static final Duration DEFAULT_QUERY_TIMEOUT = Duration.ofSeconds(5L);
        Duration cacheMaxTimeToLive = DEFAULT_CACHE_MAX_TIME_TO_LIVE;
        Duration cacheMinTimeToLive = DEFAULT_CACHE_MIN_TIME_TO_LIVE;
        Duration cacheNegativeTimeToLive = DEFAULT_CACHE_NEGATIVE_TIME_TO_LIVE;
        boolean completeOncePreferredResolved = true;
        boolean disableOptionalRecord;
        boolean disableRecursionDesired;
        HostsFileEntriesResolver hostsFileEntriesResolver;
        DnsQueryLifecycleObserverFactory loggingFactory;
        LoopResources loopResources;
        int maxPayloadSize = 4096;
        int maxQueriesPerResolve = 16;
        int ndots = -1;
        boolean preferNative = LoopResources.DEFAULT_NATIVE;
        Duration queryTimeout = DEFAULT_QUERY_TIMEOUT;
        ResolvedAddressTypes resolvedAddressTypes;
        Supplier<? extends SocketAddress> bindAddressSupplier;
        boolean roundRobinSelection;
        Iterable<String> searchDomains;

        Build() {
        }

        @Override
        public NameResolverSpec cacheMaxTimeToLive(Duration cacheMaxTimeToLive) {
            this.cacheMaxTimeToLive = Objects.requireNonNull(cacheMaxTimeToLive);
            return this;
        }

        @Override
        public NameResolverSpec cacheMinTimeToLive(Duration cacheMinTimeToLive) {
            this.cacheMinTimeToLive = Objects.requireNonNull(cacheMinTimeToLive);
            return this;
        }

        @Override
        public NameResolverSpec cacheNegativeTimeToLive(Duration cacheNegativeTimeToLive) {
            this.cacheNegativeTimeToLive = Objects.requireNonNull(cacheNegativeTimeToLive);
            return this;
        }

        @Override
        public NameResolverSpec completeOncePreferredResolved(boolean enable) {
            this.completeOncePreferredResolved = enable;
            return this;
        }

        @Override
        public NameResolverSpec disableOptionalRecord(boolean disable) {
            this.disableOptionalRecord = disable;
            return this;
        }

        @Override
        public NameResolverSpec disableRecursionDesired(boolean disable) {
            this.disableRecursionDesired = disable;
            return this;
        }

        @Override
        public NameResolverSpec hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
            this.hostsFileEntriesResolver = Objects.requireNonNull(hostsFileEntriesResolver);
            return this;
        }

        @Override
        public NameResolverSpec maxPayloadSize(int maxPayloadSize) {
            if (maxPayloadSize < 1) {
                throw new IllegalArgumentException("maxPayloadSize must be positive");
            }
            this.maxPayloadSize = maxPayloadSize;
            return this;
        }

        @Override
        public NameResolverSpec maxQueriesPerResolve(int maxQueriesPerResolve) {
            if (maxQueriesPerResolve < 1) {
                throw new IllegalArgumentException("maxQueriesPerResolve must be positive");
            }
            this.maxQueriesPerResolve = maxQueriesPerResolve;
            return this;
        }

        @Override
        public NameResolverSpec ndots(int ndots) {
            if (ndots < -1) {
                throw new IllegalArgumentException("ndots must be greater or equal to -1");
            }
            this.ndots = ndots;
            return this;
        }

        @Override
        public NameResolverSpec queryTimeout(Duration queryTimeout) {
            this.queryTimeout = Objects.requireNonNull(queryTimeout, "queryTimeout");
            return this;
        }

        @Override
        public NameResolverSpec resolvedAddressTypes(ResolvedAddressTypes resolvedAddressTypes) {
            this.resolvedAddressTypes = Objects.requireNonNull(resolvedAddressTypes);
            return this;
        }

        @Override
        public NameResolverSpec bindAddressSupplier(Supplier<? extends SocketAddress> bindAddressSupplier) {
            Objects.requireNonNull(bindAddressSupplier, "bindAddressSupplier");
            this.bindAddressSupplier = bindAddressSupplier;
            return this;
        }

        @Override
        public NameResolverSpec roundRobinSelection(boolean enable) {
            this.roundRobinSelection = enable;
            return this;
        }

        @Override
        public NameResolverSpec runOn(EventLoopGroup eventLoopGroup) {
            Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
            return this.runOn((boolean preferNative) -> eventLoopGroup);
        }

        @Override
        public NameResolverSpec runOn(LoopResources loopResources) {
            Objects.requireNonNull(loopResources, "loopResources");
            return this.runOn(loopResources, LoopResources.DEFAULT_NATIVE);
        }

        @Override
        public NameResolverSpec runOn(LoopResources loopResources, boolean preferNative) {
            Objects.requireNonNull(loopResources, "loopResources");
            this.loopResources = loopResources;
            this.preferNative = preferNative;
            return this;
        }

        @Override
        public NameResolverSpec searchDomains(List<String> searchDomains) {
            this.searchDomains = Objects.requireNonNull(searchDomains, "searchDomains");
            return this;
        }

        @Override
        public NameResolverSpec trace(String category, LogLevel level) {
            Objects.requireNonNull(category, "category");
            Objects.requireNonNull(level, "level");
            this.loggingFactory = new LoggingDnsQueryLifeCycleObserverFactory(category, level);
            return this;
        }

        @Override
        public NameResolverProvider build() {
            return new NameResolverProvider(this);
        }
    }

    public static interface NameResolverSpec {
        public NameResolverProvider build();

        public NameResolverSpec cacheMaxTimeToLive(Duration var1);

        public NameResolverSpec cacheMinTimeToLive(Duration var1);

        public NameResolverSpec cacheNegativeTimeToLive(Duration var1);

        public NameResolverSpec completeOncePreferredResolved(boolean var1);

        public NameResolverSpec disableOptionalRecord(boolean var1);

        public NameResolverSpec disableRecursionDesired(boolean var1);

        public NameResolverSpec hostsFileEntriesResolver(HostsFileEntriesResolver var1);

        public NameResolverSpec maxPayloadSize(int var1);

        public NameResolverSpec maxQueriesPerResolve(int var1);

        public NameResolverSpec ndots(int var1);

        public NameResolverSpec queryTimeout(Duration var1);

        public NameResolverSpec resolvedAddressTypes(ResolvedAddressTypes var1);

        public NameResolverSpec bindAddressSupplier(Supplier<? extends SocketAddress> var1);

        public NameResolverSpec roundRobinSelection(boolean var1);

        public NameResolverSpec runOn(EventLoopGroup var1);

        public NameResolverSpec runOn(LoopResources var1);

        public NameResolverSpec runOn(LoopResources var1, boolean var2);

        public NameResolverSpec searchDomains(List<String> var1);

        public NameResolverSpec trace(String var1, LogLevel var2);
    }
}

