/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.util.ReferenceCounted;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.Sinks;
import io.micrometer.shaded.reactor.netty.ByteBufFlux;
import io.micrometer.shaded.reactor.netty.ChannelOperationsId;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.FutureMono;
import io.micrometer.shaded.reactor.netty.NettyInbound;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.AbortedException;
import io.micrometer.shaded.reactor.netty.channel.AbstractChannelMetricsHandler;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsHandler;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperationsHandler;
import io.micrometer.shaded.reactor.netty.channel.ContextAwareChannelMetricsHandler;
import io.micrometer.shaded.reactor.netty.channel.ContextAwareChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.channel.FluxReceive;
import io.micrometer.shaded.reactor.netty.channel.MonoSendMany;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ChannelOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
implements NettyInbound,
NettyOutbound,
Connection,
CoreSubscriber<Void>,
ChannelOperationsId {
    final Connection connection;
    final FluxReceive inbound;
    final ConnectionObserver listener;
    final Sinks.Empty<Void> onTerminate;
    final String shortId;
    volatile Subscription outboundSubscription;
    boolean localActive;
    String longId;
    static final Logger log = Loggers.getLogger(ChannelOperations.class);
    static final Object TERMINATED_OPS = new Object();
    static final OnSetup EMPTY_SETUP = (c, l, msg) -> null;
    static final AtomicReferenceFieldUpdater<ChannelOperations, Subscription> OUTBOUND_CLOSE = AtomicReferenceFieldUpdater.newUpdater(ChannelOperations.class, Subscription.class, "outboundSubscription");

    public static void addReactiveBridge(Channel ch, OnSetup opsFactory, ConnectionObserver listener) {
        Objects.requireNonNull(ch, "channel");
        Objects.requireNonNull(opsFactory, "opsFactory");
        Objects.requireNonNull(listener, "listener");
        ch.pipeline().addLast("io.micrometer.shaded.reactor.right.reactiveBridge", (ChannelHandler)new ChannelOperationsHandler(opsFactory, listener));
    }

    public static void addMetricsHandler(Channel ch, ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        Objects.requireNonNull(ch, "channel");
        Objects.requireNonNull(recorder, "recorder");
        SocketAddress remote = remoteAddress;
        if (remote == null) {
            remote = ch.remoteAddress();
        }
        AbstractChannelMetricsHandler handler = recorder instanceof ContextAwareChannelMetricsRecorder ? new ContextAwareChannelMetricsHandler((ContextAwareChannelMetricsRecorder)recorder, remote, onServer) : new ChannelMetricsHandler(recorder, remote, onServer);
        ch.pipeline().addFirst("io.micrometer.shaded.reactor.left.channelMetricsHandler", (ChannelHandler)handler);
    }

    @Nullable
    public static ChannelOperations<?, ?> get(Channel ch) {
        return Connection.from(ch).as(ChannelOperations.class);
    }

    protected ChannelOperations(ChannelOperations<INBOUND, OUTBOUND> replaced) {
        this.connection = replaced.connection;
        this.listener = replaced.listener;
        this.onTerminate = replaced.onTerminate;
        this.inbound = new FluxReceive(this);
        this.shortId = replaced.shortId;
        this.longId = replaced.longId;
        this.localActive = replaced.localActive;
    }

    public ChannelOperations(Connection connection, ConnectionObserver listener) {
        this.connection = Objects.requireNonNull(connection, "connection");
        this.listener = Objects.requireNonNull(listener, "listener");
        this.onTerminate = Sinks.unsafe().empty();
        this.inbound = new FluxReceive(this);
        this.shortId = this.initShortId();
    }

    @Override
    @Nullable
    public <T extends Connection> T as(Class<T> clazz) {
        if (clazz == ChannelOperations.class) {
            ChannelOperations thiz = this;
            return (T)thiz;
        }
        return Connection.super.as(clazz);
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.connection.channel().alloc();
    }

    @Override
    public NettyInbound inbound() {
        return this;
    }

    @Override
    public NettyOutbound outbound() {
        return this;
    }

    @Override
    public final Channel channel() {
        return this.connection.channel();
    }

    @Override
    public ChannelOperations<INBOUND, OUTBOUND> withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept(this);
        return this;
    }

    @Override
    public void dispose() {
        if (log.isTraceEnabled()) {
            log.trace(ReactorNetty.format(this.channel(), "Disposing ChannelOperation from a channel"), new Exception("ChannelOperation dispose stack"));
        }
        OUTBOUND_CLOSE.set(this, Operators.cancelledSubscription());
        if (!this.inbound.isDisposed()) {
            this.discard();
        }
        this.connection.dispose();
    }

    @Override
    public CoreSubscriber<Void> disposeSubscriber() {
        return this;
    }

    @Override
    public final boolean isDisposed() {
        return !this.channel().isActive() || this.isSubscriptionDisposed();
    }

    public final boolean isSubscriptionDisposed() {
        return OUTBOUND_CLOSE.get(this) == Operators.cancelledSubscription();
    }

    @Override
    public final Mono<Void> onDispose() {
        return this.connection.onDispose();
    }

    @Override
    public Connection onDispose(Disposable onDispose) {
        this.connection.onDispose(onDispose);
        return this;
    }

    @Override
    public final void onComplete() {
        if (this.isDisposed()) {
            return;
        }
        OUTBOUND_CLOSE.set(this, Operators.cancelledSubscription());
        this.onOutboundComplete();
    }

    @Override
    public final void onError(Throwable t) {
        if (this.isDisposed()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "An outbound error could not be processed"), t);
            }
            return;
        }
        OUTBOUND_CLOSE.set(this, Operators.cancelledSubscription());
        this.onOutboundError(t);
    }

    @Override
    public final void onNext(Void aVoid) {
    }

    @Override
    public final void onSubscribe(Subscription s) {
        if (Operators.setOnce(OUTBOUND_CLOSE, this, s)) {
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public Flux<?> receiveObject() {
        return this.inbound;
    }

    @Override
    public ByteBufFlux receive() {
        return ByteBufFlux.fromInbound(this.receiveObject(), this.connection.channel().alloc());
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream, Predicate<ByteBuf> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        if (!this.channel().isActive()) {
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        if (dataStream instanceof Mono) {
            return this.then(((Mono)dataStream).flatMap(m -> FutureMono.from(this.channel().writeAndFlush(m))).doOnDiscard(ByteBuf.class, ReferenceCounted::release));
        }
        return this.then(MonoSendMany.byteBufSource(dataStream, this.channel(), predicate));
    }

    @Override
    public NettyOutbound sendObject(Publisher<?> dataStream, Predicate<Object> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        if (!this.channel().isActive()) {
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        if (dataStream instanceof Mono) {
            return this.then(((Mono)dataStream).flatMap(m -> FutureMono.from(this.channel().writeAndFlush(m))).doOnDiscard(ReferenceCounted.class, ReferenceCounted::release));
        }
        return this.then(MonoSendMany.objectSource(dataStream, this.channel(), predicate));
    }

    @Override
    public NettyOutbound sendObject(Object message) {
        if (!this.channel().isActive()) {
            ReactorNetty.safeRelease(message);
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        return this.then(FutureMono.deferFuture(() -> this.connection.channel().writeAndFlush(message)), () -> ReactorNetty.safeRelease(message));
    }

    @Override
    public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
        Objects.requireNonNull(sourceInput, "sourceInput");
        Objects.requireNonNull(mappedInput, "mappedInput");
        Objects.requireNonNull(sourceCleanup, "sourceCleanup");
        return this.then(Mono.using(sourceInput, s -> FutureMono.from(this.connection.channel().writeAndFlush(mappedInput.apply(this, (Object)s))), sourceCleanup));
    }

    @Override
    public final Mono<Void> onTerminate() {
        if (!this.isPersistent()) {
            return this.connection.onDispose();
        }
        return this.onTerminate.asMono().or(this.connection.onDispose());
    }

    public final ConnectionObserver listener() {
        return this.listener;
    }

    public String toString() {
        return "ChannelOperations{" + this.connection.toString() + "}";
    }

    public final void discard() {
        this.inbound.dispose();
    }

    protected final void discardWhenNoReceiver() {
        if (this.inbound.receiver == null) {
            this.discard();
        }
    }

    public final boolean isInboundCancelled() {
        return this.inbound.isCancelled();
    }

    public final boolean isInboundDisposed() {
        return this.inbound.isDisposed();
    }

    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        this.inbound.onInboundNext(msg);
    }

    protected void onInboundCancel() {
    }

    protected void onInboundComplete() {
        this.inbound.onInboundComplete();
    }

    protected void afterInboundComplete() {
    }

    protected void onInboundClose() {
        this.discardWhenNoReceiver();
        this.terminate();
    }

    protected void onOutboundComplete() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "[{}] User Handler requesting close connection"), this.formatName());
        }
        this.markPersistent(false);
        this.terminate();
    }

    protected void onOutboundError(Throwable err) {
        this.markPersistent(false);
        this.terminate();
    }

    protected final void terminate() {
        if (this.rebind(this.connection)) {
            if (log.isTraceEnabled()) {
                log.trace(ReactorNetty.format(this.channel(), "Disposing ChannelOperation from a channel"), new Exception("ChannelOperation terminal stack"));
            }
            Operators.terminate(OUTBOUND_CLOSE, this);
            this.onInboundComplete();
            this.afterInboundComplete();
            this.onTerminate.tryEmitEmpty();
            this.listener.onStateChange(this, ConnectionObserver.State.DISCONNECTING);
        }
    }

    protected final void onInboundError(Throwable err) {
        this.inbound.onInboundError(err);
    }

    protected final Connection connection() {
        return this.connection;
    }

    protected final String formatName() {
        return this.getClass().getSimpleName().replace("Operations", "");
    }

    protected String initShortId() {
        return this.channel().id().asShortText();
    }

    protected Throwable wrapInboundError(Throwable err) {
        if (err instanceof ClosedChannelException) {
            return new AbortedException(err);
        }
        if (err instanceof OutOfMemoryError) {
            return ReactorNetty.wrapException(err);
        }
        return err;
    }

    protected String asDebugLogMessage(Object o) {
        return o.toString();
    }

    @Override
    public boolean isPersistent() {
        return this.connection.isPersistent();
    }

    @Override
    public Context currentContext() {
        return this.listener.currentContext();
    }

    @Override
    public String asShortText() {
        return this.shortId;
    }

    @Override
    public String asLongText() {
        boolean active = this.channel().isActive();
        if (this.localActive == active && this.longId != null) {
            return this.longId;
        }
        SocketAddress remoteAddress = this.channel().remoteAddress();
        SocketAddress localAddress = this.channel().localAddress();
        String shortText = this.asShortText();
        if (remoteAddress != null) {
            String localAddressStr = String.valueOf(localAddress);
            String remoteAddressStr = String.valueOf(remoteAddress);
            StringBuilder buf = new StringBuilder(shortText.length() + 4 + localAddressStr.length() + 3 + 2 + remoteAddressStr.length()).append(shortText).append(", L:").append(localAddressStr).append(active ? " - " : " ! ").append("R:").append(remoteAddressStr);
            this.longId = buf.toString();
        } else if (localAddress != null) {
            String localAddressStr = String.valueOf(localAddress);
            StringBuilder buf = new StringBuilder(shortText.length() + 4 + localAddressStr.length()).append(shortText).append(", L:").append(localAddressStr);
            this.longId = buf.toString();
        } else {
            this.longId = shortText;
        }
        this.localActive = active;
        return this.longId;
    }

    @FunctionalInterface
    public static interface OnSetup {
        public static OnSetup empty() {
            return EMPTY_SETUP;
        }

        @Nullable
        public ChannelOperations<?, ?> create(Connection var1, ConnectionObserver var2, @Nullable Object var3);
    }
}

