/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.lang.Nullable;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontNamingConvention;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavefrontMeterRegistry
extends StepMeterRegistry {
    private final Logger logger = LoggerFactory.getLogger(WavefrontMeterRegistry.class);
    private final WavefrontConfig config;
    private final URI uri;
    private final boolean directToApi;

    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock) {
        this(config, clock, Executors.defaultThreadFactory());
    }

    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.uri = URI.create(config.uri());
        boolean bl = this.directToApi = !"proxy".equals(this.uri.getScheme());
        if (this.directToApi && config.apiToken() == null) {
            throw new MissingRequiredConfigurationException("apiToken must be set whenever publishing directly to the Wavefront API");
        }
        this.config().namingConvention((NamingConvention)new WavefrontNamingConvention(config.globalPrefix()));
        this.start(threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        try {
            for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
                Throwable throwable;
                Stream<String> stream = batch.stream().flatMap(m -> {
                    if (m instanceof Timer) {
                        return this.writeTimer((Timer)m);
                    }
                    if (m instanceof DistributionSummary) {
                        return this.writeSummary((DistributionSummary)m);
                    }
                    if (m instanceof FunctionTimer) {
                        return this.writeTimer((FunctionTimer)m);
                    }
                    return this.writeMeter((Meter)m);
                });
                if (this.directToApi) {
                    HttpURLConnection con = null;
                    try {
                        URL url = new URL(this.uri.getScheme(), this.uri.getHost(), this.uri.getPort(), String.format("/report/metrics?t=%s&h=%s", this.config.apiToken(), this.config.source()));
                        con = (HttpURLConnection)url.openConnection();
                        con.setDoOutput(true);
                        con.addRequestProperty("Content-Type", "application/json");
                        con.addRequestProperty("Accept", "application/json");
                        throwable = null;
                        try (OutputStream os = con.getOutputStream();
                             OutputStreamWriter writer = new OutputStreamWriter(os, "UTF-8");){
                            writer.write("{" + stream.collect(Collectors.joining(",")) + "}");
                            writer.flush();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        int status = con.getResponseCode();
                        if (status >= 200 && status < 300) {
                            this.logger.info("successfully sent {} metrics to Wavefront", (Object)batch.size());
                        } else {
                            try (InputStream in = con.getErrorStream();){
                                this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                            }
                        }
                        this.quietlyCloseUrlConnection(con);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    finally {
                        this.quietlyCloseUrlConnection(con);
                        continue;
                    }
                }
                Socket socket = new Socket(this.uri.getHost(), this.uri.getPort());
                Throwable throwable3 = null;
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
                    throwable = null;
                    try {
                        writer.write(stream.collect(Collectors.joining("\n")));
                        writer.flush();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable3 != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable7) {
                            throwable3.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("failed to send metrics", t);
        }
    }

    private void quietlyCloseUrlConnection(@Nullable HttpURLConnection con) {
        try {
            if (con != null) {
                con.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Stream<String> writeTimer(FunctionTimer timer) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = timer.getId();
        return Stream.of(this.writeMetric(id, "count", wallTime, timer.count()), this.writeMetric(id, "avg", wallTime, timer.mean(this.getBaseTimeUnit())), this.writeMetric(id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit())));
    }

    private Stream<String> writeTimer(Timer timer) {
        long wallTime = this.clock.wallTime();
        HistogramSnapshot snapshot = timer.takeSnapshot(false);
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        metrics.add(this.writeMetric(id, "sum", wallTime, snapshot.total(this.getBaseTimeUnit())));
        metrics.add(this.writeMetric(id, "count", wallTime, snapshot.count()));
        metrics.add(this.writeMetric(id, "avg", wallTime, snapshot.mean(this.getBaseTimeUnit())));
        metrics.add(this.writeMetric(id, "max", wallTime, snapshot.max(this.getBaseTimeUnit())));
        return metrics.build();
    }

    private Stream<String> writeSummary(DistributionSummary summary) {
        long wallTime = this.clock.wallTime();
        HistogramSnapshot snapshot = summary.takeSnapshot(false);
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = summary.getId();
        metrics.add(this.writeMetric(id, "sum", wallTime, snapshot.total()));
        metrics.add(this.writeMetric(id, "count", wallTime, snapshot.count()));
        metrics.add(this.writeMetric(id, "avg", wallTime, snapshot.mean()));
        metrics.add(this.writeMetric(id, "max", wallTime, snapshot.max()));
        return metrics.build();
    }

    private Stream<String> writeMeter(Meter m) {
        long wallTime = this.clock.wallTime();
        return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> {
            Meter.Id id = m.getId().withTag(ms.getStatistic());
            return this.writeMetric(id, null, wallTime, ms.getValue());
        });
    }

    private String writeMetric(Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        return this.directToApi ? this.writeMetricDirect(id, suffix, value) : this.writeMetricProxy(id, suffix, wallTime, value);
    }

    private String writeMetricProxy(Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        return "\"" + this.getConventionName(fullId) + "\" " + DoubleFormat.decimalOrNan((double)value) + " " + wallTime / 1000L + " source=" + this.config.source() + " " + this.getConventionTags(fullId).stream().map(t -> t.getKey() + "=\"" + t.getValue() + "\"").collect(Collectors.joining(" "));
    }

    private String writeMetricDirect(Meter.Id id, @Nullable String suffix, double value) {
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        List conventionTags = this.getConventionTags(fullId);
        String tags = conventionTags.stream().map(t -> "\"" + t.getKey() + "\": \"" + t.getValue() + "\"").collect(Collectors.joining(","));
        UUID uuid = UUID.randomUUID();
        String uniqueNameSuffix = Long.valueOf(uuid.getMostSignificantBits()).toString() + uuid.getLeastSignificantBits();
        return "\"" + this.getConventionName(fullId) + "$" + uniqueNameSuffix + "\": {\"value\": " + DoubleFormat.decimalOrNan((double)value) + ",\"tags\": {" + tags + "}}";
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return new Meter.Id(id.getName() + "." + suffix, (Iterable)id.getTags(), id.getBaseUnit(), id.getDescription(), id.getType());
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

