/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.spring.MeterRegistryConfigurer;
import io.micrometer.spring.MetricsConfigurationProperties;
import io.micrometer.spring.RecommendedMeterBinders;
import io.micrometer.spring.binder.SpringIntegrationMetrics;
import io.micrometer.spring.export.MetricsExporter;
import io.micrometer.spring.export.atlas.AtlasExportConfiguration;
import io.micrometer.spring.export.datadog.DatadogExportConfiguration;
import io.micrometer.spring.export.ganglia.GangliaExportConfiguration;
import io.micrometer.spring.export.graphite.GraphiteExportConfiguration;
import io.micrometer.spring.export.influx.InfluxExportConfiguration;
import io.micrometer.spring.export.jmx.JmxExportConfiguration;
import io.micrometer.spring.export.prometheus.PrometheusExportConfiguration;
import io.micrometer.spring.export.simple.SimpleExportConfiguration;
import io.micrometer.spring.scheduling.ScheduledMethodMetrics;
import io.micrometer.spring.web.MetricsRestTemplateConfiguration;
import io.micrometer.spring.web.MetricsServletRequestConfiguration;
import java.util.Collection;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;

@Configuration
@EnableConfigurationProperties(value={MetricsConfigurationProperties.class})
@Import(value={RecommendedMeterBinders.class, MetricsServletRequestConfiguration.class, MetricsRestTemplateConfiguration.class, AtlasExportConfiguration.class, DatadogExportConfiguration.class, GangliaExportConfiguration.class, GraphiteExportConfiguration.class, InfluxExportConfiguration.class, JmxExportConfiguration.class, PrometheusExportConfiguration.class, SimpleExportConfiguration.class})
class MetricsConfiguration {
    MetricsConfiguration() {
    }

    @ConditionalOnMissingBean(value={MeterRegistry.class})
    @Bean
    public CompositeMeterRegistry compositeMeterRegistry(ObjectProvider<Collection<MetricsExporter>> exportersProvider) {
        CompositeMeterRegistry composite = new CompositeMeterRegistry();
        if (exportersProvider.getIfAvailable() != null) {
            ((Collection)exportersProvider.getIfAvailable()).forEach(exporter -> composite.add(exporter.registry()));
        }
        return composite;
    }

    @Bean
    @ConditionalOnClass(name={"org.aspectj.lang.ProceedingJoinPoint"})
    @ConditionalOnProperty(value={"spring.aop.enabled"}, havingValue="true", matchIfMissing=true)
    public ScheduledMethodMetrics metricsSchedulingAspect(MeterRegistry registry) {
        return new ScheduledMethodMetrics(registry);
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.integration.config.EnableIntegrationManagement"})
    static class MetricsIntegrationConfiguration {
        MetricsIntegrationConfiguration() {
        }

        @Bean(name={"integrationManagementConfigurer"})
        @ConditionalOnMissingBean(value={IntegrationManagementConfigurer.class}, name={"integrationManagementConfigurer"}, search=SearchStrategy.CURRENT)
        public IntegrationManagementConfigurer managementConfigurer() {
            IntegrationManagementConfigurer configurer = new IntegrationManagementConfigurer();
            configurer.setDefaultCountsEnabled(Boolean.valueOf(true));
            configurer.setDefaultStatsEnabled(Boolean.valueOf(true));
            return configurer;
        }

        @Bean
        public SpringIntegrationMetrics springIntegrationMetrics(IntegrationManagementConfigurer configurer) {
            return new SpringIntegrationMetrics(configurer);
        }
    }

    @Configuration
    static class MeterRegistryConfigurationSupport {
        public MeterRegistryConfigurationSupport(MeterRegistry registry, MetricsConfigurationProperties config, ObjectProvider<Collection<MeterBinder>> binders, ObjectProvider<Collection<MeterRegistryConfigurer>> registryConfigurers) {
            if (registryConfigurers.getIfAvailable() != null) {
                ((Collection)registryConfigurers.getIfAvailable()).forEach(conf -> conf.configureRegistry(registry));
            }
            if (binders.getIfAvailable() != null) {
                ((Collection)binders.getIfAvailable()).forEach(binder -> binder.bindTo(registry));
            }
            if (config.getUseGlobalRegistry().booleanValue()) {
                Metrics.addRegistry((MeterRegistry)registry);
            }
        }
    }
}

