/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.ExecutorServiceMetrics;
import io.micrometer.spring.binder.DataSourceMetrics;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class SpringMeters {
    public static DataSource monitor(MeterRegistry registry, DataSource dataSource, Collection<DataSourcePoolMetadataProvider> metadataProviders, String name, Iterable<Tag> tags) {
        new DataSourceMetrics(dataSource, metadataProviders, name, tags).bindTo(registry);
        return dataSource;
    }

    public static DataSource monitor(MeterRegistry registry, DataSource dataSource, Collection<DataSourcePoolMetadataProvider> metadataProviders, String name, Tag ... tags) {
        return SpringMeters.monitor(registry, dataSource, metadataProviders, name, Arrays.asList(tags));
    }

    public static ThreadPoolTaskExecutor monitor(MeterRegistry registry, ThreadPoolTaskExecutor executor, String name, Iterable<Tag> tags) {
        ExecutorServiceMetrics.monitor((MeterRegistry)registry, (ExecutorService)executor.getThreadPoolExecutor(), (String)name, tags);
        return executor;
    }

    public static ThreadPoolTaskExecutor monitor(MeterRegistry registry, ThreadPoolTaskExecutor executor, String name, Tag ... tags) {
        ExecutorServiceMetrics.monitor((MeterRegistry)registry, (ExecutorService)executor.getThreadPoolExecutor(), (String)name, (Tag[])tags);
        return executor;
    }

    public static ThreadPoolTaskScheduler monitor(MeterRegistry registry, ThreadPoolTaskScheduler scheduler, String name, Iterable<Tag> tags) {
        ExecutorServiceMetrics.monitor((MeterRegistry)registry, (ExecutorService)scheduler.getScheduledExecutor(), (String)name, tags);
        return scheduler;
    }

    public static ThreadPoolTaskScheduler monitor(MeterRegistry registry, ThreadPoolTaskScheduler scheduler, String name, Tag ... tags) {
        ExecutorServiceMetrics.monitor((MeterRegistry)registry, (ExecutorService)scheduler.getScheduledExecutor(), (String)name, (Tag[])tags);
        return scheduler;
    }
}

