/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.PollableChannelManagement;

public class SpringIntegrationMetrics
implements MeterBinder,
SmartInitializingSingleton {
    private final Iterable<Tag> tags;
    private Collection<MeterRegistry> registries = new ArrayList<MeterRegistry>();
    private final IntegrationManagementConfigurer configurer;

    public SpringIntegrationMetrics(IntegrationManagementConfigurer configurer) {
        this(configurer, Collections.emptyList());
    }

    public SpringIntegrationMetrics(IntegrationManagementConfigurer configurer, Iterable<Tag> tags) {
        this.configurer = configurer;
        this.tags = tags;
    }

    public void bindTo(MeterRegistry registry) {
        registry.gauge(registry.createId("spring.integration.channelNames", this.tags, "The number of spring integration channels"), (Object)this.configurer, c -> c.getChannelNames().length);
        registry.gauge(registry.createId("spring.integration.handlerNames", this.tags, "The number of spring integration handlers"), (Object)this.configurer, c -> c.getHandlerNames().length);
        registry.gauge(registry.createId("spring.integration.sourceNames", this.tags, "The number of spring integration sources"), (Object)this.configurer, c -> c.getSourceNames().length);
        this.registries.add(registry);
    }

    private void addSourceMetrics(MeterRegistry registry) {
        for (String source : this.configurer.getSourceNames()) {
            MessageSourceMetrics sourceMetrics = this.configurer.getSourceMetrics(source);
            Iterable tagsWithSource = Tags.concat(this.tags, (String[])new String[]{"source", source});
            registry.more().counter(registry.createId("spring.integration.source.messages", tagsWithSource, "The number of successful handler calls"), (Object)sourceMetrics, MessageSourceMetrics::getMessageCount);
        }
    }

    private void addHandlerMetrics(MeterRegistry registry) {
        for (String handler : this.configurer.getHandlerNames()) {
            MessageHandlerMetrics handlerMetrics = this.configurer.getHandlerMetrics(handler);
            Iterable tagsWithHandler = Tags.concat(this.tags, (String[])new String[]{"handler", handler});
            registry.more().timeGauge(registry.createId("spring.integration.handler.duration.max", tagsWithHandler, "The maximum handler duration"), (Object)handlerMetrics, TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMaxDuration);
            registry.more().timeGauge(registry.createId("spring.integration.handler.duration.min", tagsWithHandler, "The minimum handler duration"), (Object)handlerMetrics, TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMinDuration);
            registry.more().timeGauge(registry.createId("spring.integration.handler.duration.mean", tagsWithHandler, "The mean handler duration"), (Object)handlerMetrics, TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMeanDuration);
            registry.gauge(registry.createId("spring.integration.handler.activeCount", tagsWithHandler, "The number of active handlers"), (Object)handlerMetrics, MessageHandlerMetrics::getActiveCount);
        }
    }

    private void addChannelMetrics(MeterRegistry registry) {
        for (String channel : this.configurer.getChannelNames()) {
            MessageChannelMetrics channelMetrics = this.configurer.getChannelMetrics(channel);
            Iterable tagsWithChannel = Tags.concat(this.tags, (String[])new String[]{"channel", channel});
            registry.more().counter(registry.createId("spring.integration.channel.sendErrors", tagsWithChannel, "The number of failed sends (either throwing an exception or rejected by the channel)"), (Object)channelMetrics, MessageChannelMetrics::getSendErrorCount);
            registry.more().counter(registry.createId("spring.integration.channel.sends", tagsWithChannel, "The number of successful sends"), (Object)channelMetrics, MessageChannelMetrics::getSendCount);
            if (!(channelMetrics instanceof PollableChannelManagement)) continue;
            registry.more().counter(registry.createId("spring.integration.receives", tagsWithChannel, "The number of messages received"), (Object)((PollableChannelManagement)channelMetrics), PollableChannelManagement::getReceiveCount);
        }
    }

    public void afterSingletonsInstantiated() {
        this.configurer.afterSingletonsInstantiated();
        this.registries.forEach(registry -> {
            this.addChannelMetrics((MeterRegistry)registry);
            this.addHandlerMetrics((MeterRegistry)registry);
            this.addSourceMetrics((MeterRegistry)registry);
        });
    }
}

