/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.export.atlas;

import com.netflix.spectator.atlas.AtlasConfig;
import io.micrometer.atlas.AtlasMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.spring.export.DurationConverter;
import io.micrometer.spring.export.MetricsExporter;
import io.micrometer.spring.export.atlas.AtlasConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(name={"io.micrometer.atlas.AtlasMeterRegistry"})
@Import(value={DurationConverter.class})
@EnableConfigurationProperties(value={AtlasConfigurationProperties.class})
public class AtlasExportConfiguration {
    @ConditionalOnProperty(value={"metrics.atlas.enabled"}, matchIfMissing=true)
    @Bean
    public MetricsExporter atlasExporter(AtlasConfig config, Clock clock) {
        return () -> new AtlasMeterRegistry(config, clock);
    }

    @ConditionalOnMissingBean
    @Bean
    public Clock clock() {
        return Clock.SYSTEM;
    }
}

