/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.export.datadog;

import io.micrometer.core.instrument.Clock;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMeterRegistry;
import io.micrometer.spring.export.DurationConverter;
import io.micrometer.spring.export.MetricsExporter;
import io.micrometer.spring.export.datadog.DatadogConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(name={"io.micrometer.datadog.DatadogMeterRegistry"})
@Import(value={DurationConverter.class})
@EnableConfigurationProperties(value={DatadogConfigurationProperties.class})
public class DatadogExportConfiguration {
    @ConditionalOnProperty(value={"metrics.datadog.enabled"}, matchIfMissing=true)
    @Bean
    public MetricsExporter datadogExporter(DatadogConfig config, Clock clock) {
        return () -> new DatadogMeterRegistry(config, clock);
    }

    @ConditionalOnMissingBean
    @Bean
    public Clock clock() {
        return Clock.SYSTEM;
    }
}

