/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.export.ganglia;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.ganglia.GangliaConfig;
import io.micrometer.ganglia.GangliaMeterRegistry;
import io.micrometer.spring.export.DurationConverter;
import io.micrometer.spring.export.MetricsExporter;
import io.micrometer.spring.export.ganglia.GangliaConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(name={"io.micrometer.ganglia.GangliaMeterRegistry"})
@Import(value={DurationConverter.class})
@EnableConfigurationProperties(value={GangliaConfigurationProperties.class})
public class GangliaExportConfiguration {
    @ConditionalOnProperty(value={"metrics.ganglia.enabled"}, matchIfMissing=true)
    @Bean
    public MetricsExporter gangliaExporter(GangliaConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        return () -> new GangliaMeterRegistry(config, nameMapper, clock);
    }

    @ConditionalOnMissingBean
    @Bean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    @ConditionalOnMissingBean
    @Bean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }
}

