/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.export.graphite;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micrometer.spring.export.DurationConverter;
import io.micrometer.spring.export.MetricsExporter;
import io.micrometer.spring.export.graphite.GraphiteConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(name={"io.micrometer.graphite.GraphiteMeterRegistry"})
@Import(value={DurationConverter.class})
@EnableConfigurationProperties(value={GraphiteConfigurationProperties.class})
public class GraphiteExportConfiguration {
    @ConditionalOnProperty(value={"metrics.graphite.enabled"}, matchIfMissing=true)
    @Bean
    public MetricsExporter graphiteExporter(GraphiteConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        return () -> new GraphiteMeterRegistry(config, nameMapper, clock);
    }

    @ConditionalOnMissingBean
    @Bean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    @ConditionalOnMissingBean
    @Bean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }
}

