/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.export.influx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxMeterRegistry;
import io.micrometer.spring.export.DurationConverter;
import io.micrometer.spring.export.MetricsExporter;
import io.micrometer.spring.export.influx.InfluxConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(name={"io.micrometer.influx.InfluxMeterRegistry"})
@Import(value={DurationConverter.class})
@EnableConfigurationProperties(value={InfluxConfigurationProperties.class})
public class InfluxExportConfiguration {
    @ConditionalOnProperty(value={"metrics.influx.enabled"}, matchIfMissing=true)
    @Bean
    public MetricsExporter influxExporter(InfluxConfig config, Clock clock) {
        return () -> new InfluxMeterRegistry(config, clock);
    }

    @ConditionalOnMissingBean
    @Bean
    public Clock clock() {
        return Clock.SYSTEM;
    }
}

