/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.export.jmx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.jmx.JmxMeterRegistry;
import io.micrometer.spring.export.MetricsExporter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"io.micrometer.jmx.JmxMeterRegistry"})
public class JmxExportConfiguration {
    @ConditionalOnProperty(value={"metrics.jmx.enabled"}, matchIfMissing=true)
    @Bean
    public MetricsExporter jmxExporter(HierarchicalNameMapper nameMapper, Clock clock) {
        return () -> new JmxMeterRegistry(nameMapper, clock);
    }

    @ConditionalOnMissingBean
    @Bean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    @ConditionalOnMissingBean
    @Bean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }
}

