/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.export.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.spring.export.MetricsExporter;
import io.micrometer.spring.export.prometheus.PrometheusActuatorEndpoint;
import io.micrometer.spring.export.prometheus.PrometheusConfigurationProperties;
import io.prometheus.client.CollectorRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"io.micrometer.prometheus.PrometheusMeterRegistry"})
@EnableConfigurationProperties(value={PrometheusConfigurationProperties.class})
public class PrometheusExportConfiguration {
    @ConditionalOnProperty(value={"metrics.prometheus.enabled"}, matchIfMissing=true)
    @Bean
    MetricsExporter prometheusExporter(PrometheusConfig config, CollectorRegistry collectorRegistry, Clock clock) {
        return () -> new PrometheusMeterRegistry(config, collectorRegistry, clock);
    }

    @ConditionalOnMissingBean
    @Bean
    CollectorRegistry collectorRegistry() {
        return new CollectorRegistry(true);
    }

    @ConditionalOnMissingBean
    @Bean
    Clock clock() {
        return Clock.SYSTEM;
    }

    @ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.Endpoint"})
    @Configuration
    static class PrometheusScrapeEndpointConfiguration {
        PrometheusScrapeEndpointConfiguration() {
        }

        @Bean
        public PrometheusActuatorEndpoint prometheusEndpoint(CollectorRegistry collectorRegistry) {
            return new PrometheusActuatorEndpoint(collectorRegistry);
        }
    }
}

