/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.export.simple;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.spring.export.MetricsExporter;
import io.micrometer.spring.export.simple.SimpleConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SimpleConfigurationProperties.class})
public class SimpleExportConfiguration {
    @ConditionalOnProperty(value={"metrics.simple.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={MetricsExporter.class})
    @Bean
    MetricsExporter simpleExporter(Clock clock) {
        return () -> new SimpleMeterRegistry(clock);
    }

    @ConditionalOnMissingBean
    @Bean
    Clock clock() {
        return Clock.SYSTEM;
    }
}

