/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.scheduling;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.stats.quantile.WindowSketchQuantiles;
import io.micrometer.core.instrument.util.AnnotationUtils;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ScheduledMethodMetrics {
    private static final Log logger = LogFactory.getLog(ScheduledMethodMetrics.class);
    private final MeterRegistry registry;

    public ScheduledMethodMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    @Around(value="execution (@org.springframework.scheduling.annotation.Scheduled  * *.*(..))")
    public Object timeScheduledOperation(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        String signature = pjp.getSignature().toShortString();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = pjp.getTarget().getClass().getDeclaredMethod(pjp.getSignature().getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.warn((Object)("Unable to perform metrics timing on " + signature), (Throwable)e);
                return pjp.proceed();
            }
        }
        Timer shortTaskTimer = null;
        LongTaskTimer longTaskTimer = null;
        for (Timed timed : (Timed[])AnnotationUtils.findTimed((Method)method).toArray(Timed[]::new)) {
            if (timed.longTask()) {
                longTaskTimer = this.registry.more().longTaskTimer(this.registry.createId(timed.value(), (Iterable)Tags.zip((String[])timed.extraTags()), "Timer of @Scheduled long task"));
                continue;
            }
            Timer.Builder timerBuilder = Timer.builder((String)timed.value()).tags(timed.extraTags()).description("Timer of @Scheduled task");
            if (timed.quantiles().length > 0) {
                timerBuilder = timerBuilder.quantiles((Quantiles)WindowSketchQuantiles.quantiles((double[])timed.quantiles()).create());
            }
            shortTaskTimer = timerBuilder.register(this.registry);
        }
        if (shortTaskTimer != null && longTaskTimer != null) {
            Timer finalTimer = shortTaskTimer;
            return this.recordThrowable(longTaskTimer, () -> this.recordThrowable(finalTimer, () -> ((ProceedingJoinPoint)pjp).proceed()));
        }
        if (shortTaskTimer != null) {
            return this.recordThrowable(shortTaskTimer, () -> ((ProceedingJoinPoint)pjp).proceed());
        }
        if (longTaskTimer != null) {
            return this.recordThrowable(longTaskTimer, () -> ((ProceedingJoinPoint)pjp).proceed());
        }
        return pjp.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object recordThrowable(LongTaskTimer timer, ThrowableCallable f) throws Throwable {
        long id = timer.start();
        try {
            Object object = f.call();
            return object;
        }
        finally {
            timer.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object recordThrowable(Timer timer, ThrowableCallable f) throws Throwable {
        long start = this.registry.config().clock().monotonicTime();
        try {
            Object object = f.call();
            return object;
        }
        finally {
            timer.record(this.registry.config().clock().monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private static interface ThrowableCallable {
        public Object call() throws Throwable;
    }
}

