/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.stats.quantile.WindowSketchQuantiles;
import io.micrometer.core.instrument.util.AnnotationUtils;
import io.micrometer.spring.MetricsConfigurationProperties;
import io.micrometer.spring.web.WebServletTagConfigurer;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.method.HandlerMethod;

public class ControllerMetrics {
    private static final String TIMING_REQUEST_ATTRIBUTE = "micrometer.requestStartTime";
    private static final String HANDLER_REQUEST_ATTRIBUTE = "micrometer.requestHandler";
    private static final String EXCEPTION_ATTRIBUTE = "micrometer.requestException";
    private static final Log logger = LogFactory.getLog(ControllerMetrics.class);
    private final MeterRegistry registry;
    private MetricsConfigurationProperties properties;
    private final WebServletTagConfigurer tagConfigurer;
    private final Map<HttpServletRequest, Long> longTaskTimerIds = Collections.synchronizedMap(new IdentityHashMap());

    public ControllerMetrics(MeterRegistry registry, MetricsConfigurationProperties properties, WebServletTagConfigurer tagConfigurer) {
        this.registry = registry;
        this.properties = properties;
        this.tagConfigurer = tagConfigurer;
    }

    public void tagWithException(Throwable t) {
        RequestContextHolder.getRequestAttributes().setAttribute(EXCEPTION_ATTRIBUTE, (Object)t, 0);
    }

    public void preHandle(HttpServletRequest request, Object handler) {
        request.setAttribute(TIMING_REQUEST_ATTRIBUTE, (Object)System.nanoTime());
        request.setAttribute(HANDLER_REQUEST_ATTRIBUTE, handler);
        this.longTaskTimed(handler).forEach(t -> {
            if (t.name == null) {
                if (handler instanceof HandlerMethod) {
                    logger.warn((Object)("Unable to perform metrics timing on " + ((HandlerMethod)handler).getShortLogMessage() + ": @Timed annotation must have a value used to name the metric"));
                } else {
                    logger.warn((Object)("Unable to perform metrics timing for request " + request.getRequestURI() + ": @Timed annotation must have a value used to name the metric"));
                }
                return;
            }
            this.longTaskTimerIds.put(request, this.longTaskTimer((TimerConfig)t, request, handler).start());
        });
    }

    public void record(HttpServletRequest request, HttpServletResponse response, Throwable ex) {
        Long startTime = (Long)request.getAttribute(TIMING_REQUEST_ATTRIBUTE);
        Object handler = request.getAttribute(HANDLER_REQUEST_ATTRIBUTE);
        long endTime = System.nanoTime();
        Throwable thrown = ex != null ? ex : (Throwable)request.getAttribute(EXCEPTION_ATTRIBUTE);
        this.longTaskTimed(handler).forEach(t -> {
            if (t.name != null) {
                this.longTaskTimer((TimerConfig)t, request, handler).stop(this.longTaskTimerIds.remove(request).longValue());
            }
        });
        this.timed(handler).forEach(t -> {
            Timer.Builder timerBuilder = Timer.builder((String)t.name).tags(this.tagConfigurer.httpRequestTags(request, response, thrown)).tags(t.extraTags).description("Timer of servlet request");
            if (t.quantiles.length > 0) {
                timerBuilder = timerBuilder.quantiles((Quantiles)WindowSketchQuantiles.quantiles((double[])t.quantiles).create());
            }
            if (t.percentiles) {
                timerBuilder = timerBuilder.histogram(Histogram.percentilesTime());
            }
            timerBuilder.register(this.registry).record(endTime - startTime, TimeUnit.NANOSECONDS);
        });
    }

    private LongTaskTimer longTaskTimer(TimerConfig t, HttpServletRequest request, Object handler) {
        Iterable tags = Tags.concat(this.tagConfigurer.httpLongRequestTags(request, handler), t.extraTags);
        return this.registry.more().longTaskTimer(this.registry.createId(t.name, tags, "Timer of long servlet request"));
    }

    private Set<TimerConfig> longTaskTimed(Object m) {
        if (!(m instanceof HandlerMethod)) {
            return Collections.emptySet();
        }
        Set<TimerConfig> timed = AnnotationUtils.findTimed((Method)((HandlerMethod)m).getMethod()).filter(Timed::longTask).map(this::fromAnnotation).collect(Collectors.toSet());
        if (timed.isEmpty()) {
            return AnnotationUtils.findTimed((Class)((HandlerMethod)m).getBeanType()).filter(Timed::longTask).map(this::fromAnnotation).collect(Collectors.toSet());
        }
        return timed;
    }

    private Set<TimerConfig> timed(Object m) {
        if (!(m instanceof HandlerMethod)) {
            return Collections.emptySet();
        }
        Set<TimerConfig> timed = AnnotationUtils.findTimed((Method)((HandlerMethod)m).getMethod()).filter(t -> !t.longTask()).map(this::fromAnnotation).collect(Collectors.toSet());
        if (timed.isEmpty() && (timed = AnnotationUtils.findTimed((Class)((HandlerMethod)m).getBeanType()).filter(t -> !t.longTask()).map(this::fromAnnotation).collect(Collectors.toSet())).isEmpty() && this.properties.getWeb().getAutoTimeServerRequests().booleanValue()) {
            return Collections.singleton(new TimerConfig());
        }
        return timed;
    }

    private TimerConfig fromAnnotation(Timed timed) {
        TimerConfig c = new TimerConfig();
        String string = c.name = timed.value().isEmpty() ? this.properties.getWeb().getServerRequestsName() : timed.value();
        if (c.longTask && timed.value().isEmpty()) {
            c.name = null;
        }
        c.extraTags = Tags.zip((String[])timed.extraTags());
        c.longTask = timed.longTask();
        c.quantiles = timed.quantiles();
        c.percentiles = timed.percentiles();
        return c;
    }

    private class TimerConfig {
        String name;
        Iterable<Tag> extraTags;
        boolean longTask;
        double[] quantiles;
        boolean percentiles;

        private TimerConfig() {
            this.name = ControllerMetrics.this.properties.getWeb().getServerRequestsName();
            this.extraTags = Collections.emptyList();
            this.longTask = false;
            this.quantiles = new double[0];
            this.percentiles = ControllerMetrics.this.properties.getWeb().getServerRequestPercentiles();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimerConfig that = (TimerConfig)o;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

