/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.MetricsConfigurationProperties;
import io.micrometer.spring.web.MetricsRestTemplateInterceptor;
import io.micrometer.spring.web.RestTemplateTagConfigurer;
import io.micrometer.spring.web.RestTemplateUrlTemplateCapturingAspect;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
public class MetricsRestTemplateConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RestTemplateTagConfigurer.class})
    RestTemplateTagConfigurer restTemplateTagConfigurer() {
        return new RestTemplateTagConfigurer();
    }

    @Bean
    MetricsRestTemplateInterceptor clientHttpRequestInterceptor(MeterRegistry meterRegistry, RestTemplateTagConfigurer restTemplateTagConfigurer, MetricsConfigurationProperties properties) {
        return new MetricsRestTemplateInterceptor(meterRegistry, restTemplateTagConfigurer, properties);
    }

    @Bean
    static BeanPostProcessor restTemplateInterceptorPostProcessor() {
        return new MetricsInterceptorPostProcessor();
    }

    @Configuration
    @ConditionalOnClass(name={"org.aspectj.lang.ProceedingJoinPoint"})
    @ConditionalOnProperty(value={"spring.aop.enabled"}, havingValue="true", matchIfMissing=true)
    static class MetricsRestTemplateAspectConfiguration {
        MetricsRestTemplateAspectConfiguration() {
        }

        @Bean
        RestTemplateUrlTemplateCapturingAspect restTemplateUrlTemplateCapturingAspect() {
            return new RestTemplateUrlTemplateCapturingAspect();
        }
    }

    private static class MetricsInterceptorPostProcessor
    implements BeanPostProcessor,
    ApplicationContextAware {
        private ApplicationContext context;
        private MetricsRestTemplateInterceptor interceptor;

        private MetricsInterceptorPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof RestTemplate) {
                if (this.interceptor == null) {
                    this.interceptor = (MetricsRestTemplateInterceptor)this.context.getBean(MetricsRestTemplateInterceptor.class);
                }
                RestTemplate restTemplate = (RestTemplate)bean;
                ArrayList<MetricsRestTemplateInterceptor> interceptors = new ArrayList<MetricsRestTemplateInterceptor>();
                interceptors.add(this.interceptor);
                interceptors.addAll(restTemplate.getInterceptors());
                restTemplate.setInterceptors(interceptors);
            }
            return bean;
        }

        public void setApplicationContext(ApplicationContext context) throws BeansException {
            this.context = context;
        }
    }
}

