/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.spring.MetricsConfigurationProperties;
import io.micrometer.spring.web.RestTemplateTagConfigurer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class MetricsRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private final MeterRegistry meterRegistry;
    private final RestTemplateTagConfigurer tagProvider;
    private final MetricsConfigurationProperties properties;

    public MetricsRestTemplateInterceptor(MeterRegistry meterRegistry, RestTemplateTagConfigurer tagProvider, MetricsConfigurationProperties properties) {
        this.tagProvider = tagProvider;
        this.meterRegistry = meterRegistry;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        long startTime = System.nanoTime();
        ClientHttpResponse response = null;
        try {
            ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
            return clientHttpResponse;
        }
        finally {
            Timer.Builder builder = Timer.builder((String)this.properties.getWeb().getClientRequestsName()).tags(this.tagProvider.clientHttpRequestTags(request, response)).description("Timer of RestTemplate operation");
            if (this.properties.getWeb().getClientRequestPercentiles().booleanValue()) {
                builder = builder.histogram(Histogram.percentiles());
            }
            builder.register(this.meterRegistry).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }
}

