/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.MetricsConfigurationProperties;
import io.micrometer.spring.web.ControllerMetrics;
import io.micrometer.spring.web.MetricsHandlerInterceptor;
import io.micrometer.spring.web.WebServletTagConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={MetricsConfigurationProperties.class})
public class MetricsServletRequestConfiguration
extends WebMvcConfigurerAdapter {
    @Bean
    @ConditionalOnMissingBean(value={WebServletTagConfigurer.class})
    WebServletTagConfigurer webmvcTagConfigurer() {
        return new WebServletTagConfigurer();
    }

    @Bean
    ControllerMetrics controllerMetrics(MeterRegistry registry, MetricsConfigurationProperties properties, WebServletTagConfigurer configurer) {
        return new ControllerMetrics(registry, properties, configurer);
    }

    @Bean
    MetricsHandlerInterceptor webMetricsInterceptor(ControllerMetrics controllerMetrics) {
        return new MetricsHandlerInterceptor(controllerMetrics);
    }

    @Configuration
    class MetricsServletRequestInterceptorConfiguration
    extends WebMvcConfigurerAdapter {
        @Autowired
        MetricsHandlerInterceptor handlerInterceptor;

        MetricsServletRequestInterceptorConfiguration() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.handlerInterceptor);
        }
    }
}

