/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web;

import io.micrometer.core.instrument.Tag;
import io.micrometer.spring.web.RestTemplateUrlTemplateHolder;
import java.io.IOException;
import java.util.Arrays;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateTagConfigurer {
    Iterable<Tag> clientHttpRequestTags(HttpRequest request, ClientHttpResponse response) {
        return Arrays.asList(this.method(request), this.uri(), this.status(response), this.clientName(request));
    }

    public Tag method(HttpRequest request) {
        return Tag.of((String)"method", (String)request.getMethod().name());
    }

    public Tag uri() {
        String urlTemplate = RestTemplateUrlTemplateHolder.getRestTemplateUrlTemplate();
        if (urlTemplate == null) {
            urlTemplate = "none";
        }
        String strippedUrlTemplate = urlTemplate.replaceAll("^https?://[^/]+/", "");
        return Tag.of((String)"uri", (String)strippedUrlTemplate);
    }

    public Tag status(ClientHttpResponse response) {
        String status;
        try {
            status = response == null ? "CLIENT_ERROR" : Integer.valueOf(response.getRawStatusCode()).toString();
        }
        catch (IOException e) {
            status = "IO_ERROR";
        }
        return Tag.of((String)"status", (String)status);
    }

    public Tag clientName(HttpRequest request) {
        String host = request.getURI().getHost();
        if (host == null) {
            host = "none";
        }
        return Tag.of((String)"clientName", (String)host);
    }
}

