/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web;

import io.micrometer.spring.web.RestTemplateUrlTemplateHolder;
import java.net.URI;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class RestTemplateUrlTemplateCapturingAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* org.springframework.web.client.RestOperations+.*(String, ..))")
    Object captureUrlTemplate(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            String urlTemplate = (String)joinPoint.getArgs()[0];
            RestTemplateUrlTemplateHolder.setRestTemplateUrlTemplate(urlTemplate);
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            RestTemplateUrlTemplateHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* org.springframework.web.client.RestOperations+.*(java.net.URI, ..))")
    Object captureUrlTemplateFromURI(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            URI urlTemplate = (URI)joinPoint.getArgs()[0];
            RestTemplateUrlTemplateHolder.setRestTemplateUrlTemplate(urlTemplate.toString());
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            RestTemplateUrlTemplateHolder.clear();
        }
    }
}

