/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web;

import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;

public class WebServletTagConfigurer {
    public static WebServletTagConfigurer DEFAULT = new WebServletTagConfigurer();

    public Iterable<Tag> httpLongRequestTags(HttpServletRequest request, Object handler) {
        return Arrays.asList(this.method(request), this.uri(request));
    }

    public Iterable<Tag> httpRequestTags(HttpServletRequest request, HttpServletResponse response, Throwable ex) {
        return this.defaultHttpRequestTags(request, response, ex);
    }

    private Iterable<Tag> defaultHttpRequestTags(HttpServletRequest request, HttpServletResponse response, Throwable ex) {
        return Arrays.asList(this.method(request), this.uri(request), this.exception(ex), this.status(response));
    }

    private Iterable<Tag> defaultHttpLongRequestTags(HttpServletRequest request, Object handler) {
        return Arrays.asList(this.method(request), this.uri(request));
    }

    public Tag method(HttpServletRequest request) {
        return Tag.of((String)"method", (String)request.getMethod());
    }

    public Tag status(HttpServletResponse response) {
        return Tag.of((String)"status", (String)Integer.valueOf(response.getStatus()).toString());
    }

    public Tag uri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (uri == null) {
            uri = request.getPathInfo();
        }
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        return Tag.of((String)"uri", (String)(uri.isEmpty() ? "root" : uri));
    }

    public Tag exception(Throwable exception) {
        if (exception != null) {
            return Tag.of((String)"exception", (String)exception.getClass().getSimpleName());
        }
        return Tag.of((String)"exception", (String)"None");
    }
}

