/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.web.servlet;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.web.servlet.DefaultWebMvcTagsProvider;
import io.micrometer.spring.web.servlet.WebMvcMetricsFilter;
import io.micrometer.spring.web.servlet.WebMvcTagsProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Configuration
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={MetricsProperties.class})
public class ServletMetricsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WebMvcTagsProvider.class})
    public DefaultWebMvcTagsProvider servletTagsProvider() {
        return new DefaultWebMvcTagsProvider();
    }

    @Bean
    public WebMvcMetricsFilter webMetricsFilter(MeterRegistry registry, MetricsProperties properties, WebMvcTagsProvider tagsProvider, WebApplicationContext ctx) {
        return new WebMvcMetricsFilter(registry, tagsProvider, properties.getWeb().getServer().getRequestsMetricName(), properties.getWeb().getServer().isAutoTimeRequests(), new HandlerMappingIntrospector((ApplicationContext)ctx));
    }
}

