/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.web.tomcat;

import io.micrometer.core.instrument.binder.tomcat.TomcatMetrics;
import io.micrometer.core.lang.Nullable;
import java.util.Collections;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"org.apache.catalina.startup.Tomcat"})
public class TomcatMetricsConfiguration {
    @Bean
    public TomcatMetrics metrics(ApplicationContext applicationContext) {
        Manager manager = null;
        if (applicationContext instanceof EmbeddedWebApplicationContext) {
            manager = this.getManagerFromContext((EmbeddedWebApplicationContext)applicationContext);
        }
        return new TomcatMetrics(manager, Collections.emptyList());
    }

    @Nullable
    private Manager getManagerFromContext(EmbeddedWebApplicationContext applicationContext) {
        EmbeddedServletContainer embeddedServletContainer = applicationContext.getEmbeddedServletContainer();
        if (embeddedServletContainer instanceof TomcatEmbeddedServletContainer) {
            return this.getManagerFromContainer((TomcatEmbeddedServletContainer)embeddedServletContainer);
        }
        return null;
    }

    @Nullable
    private Manager getManagerFromContainer(TomcatEmbeddedServletContainer servletContainer) {
        for (Container container : servletContainer.getTomcat().getHost().findChildren()) {
            if (!(container instanceof Context)) continue;
            return ((Context)container).getManager();
        }
        return null;
    }
}

