/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.lang.Nullable;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;

public class ConcurrentMapCacheMetrics
extends CacheMeterBinder {
    private final MonitoredConcurrentMapCache cache;

    public static ConcurrentMapCache monitor(MeterRegistry registry, ConcurrentMapCache cache, String ... tags) {
        return ConcurrentMapCacheMetrics.monitor(registry, cache, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public static ConcurrentMapCache monitor(MeterRegistry registry, ConcurrentMapCache cache, Iterable<Tag> tags) {
        new ConcurrentMapCacheMetrics(cache, tags).bindTo(registry);
        return cache;
    }

    public ConcurrentMapCacheMetrics(ConcurrentMapCache cache, Iterable<Tag> tags) {
        super((Object)cache, cache.getName(), tags);
        this.cache = new MonitoredConcurrentMapCache(cache);
    }

    public MonitoredConcurrentMapCache getMonitoredCache() {
        return this.cache;
    }

    protected Long size() {
        return this.cache.getNativeCache().size();
    }

    protected long hitCount() {
        return this.cache.hitCount.get();
    }

    protected long missCount() {
        return this.cache.missCount.get();
    }

    protected Long evictionCount() {
        return this.cache.evictCount.get();
    }

    protected long putCount() {
        return this.cache.putCount.get();
    }

    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
    }

    public static class MonitoredConcurrentMapCache
    extends ConcurrentMapCache {
        private AtomicLong hitCount = new AtomicLong(0L);
        private AtomicLong missCount = new AtomicLong(0L);
        private AtomicLong putCount = new AtomicLong(0L);
        private AtomicLong evictCount = new AtomicLong(0L);
        private ConcurrentMapCache delegate;

        MonitoredConcurrentMapCache(ConcurrentMapCache delegate) {
            super(delegate.getName(), delegate.getNativeCache(), delegate.isAllowNullValues());
            this.delegate = delegate;
        }

        public Cache.ValueWrapper get(Object key) {
            this.countGet(key);
            return this.delegate.get(key);
        }

        public <T> T get(Object key, Class<T> type) {
            this.countGet(key);
            return (T)this.delegate.get(key, type);
        }

        @Nullable
        public <T> T get(Object key, Callable<T> valueLoader) {
            this.countGet(key);
            return (T)this.delegate.get(key, valueLoader);
        }

        @Nullable
        private Cache.ValueWrapper countGet(Object key) {
            Cache.ValueWrapper valueWrapper = this.delegate.get(key);
            if (valueWrapper != null) {
                this.hitCount.incrementAndGet();
            } else {
                this.missCount.incrementAndGet();
            }
            return valueWrapper;
        }

        public void put(Object key, Object value) {
            this.putCount.incrementAndGet();
            this.delegate.put(key, value);
        }

        public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
            if (!this.getNativeCache().containsKey(key)) {
                this.putCount.incrementAndGet();
            }
            return this.delegate.putIfAbsent(key, value);
        }

        public void evict(Object key) {
            this.evictCount.incrementAndGet();
            this.delegate.evict(key);
        }

        public void clear() {
            this.delegate.clear();
        }
    }
}

