/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.signalfx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.signalfx.SignalFxConfig;
import io.micrometer.signalfx.SignalFxMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.signalfx.SignalFxProperties;
import io.micrometer.spring.autoconfigure.export.signalfx.SignalFxPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={SignalFxMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.signalfx", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SignalFxProperties.class})
@Import(value={StringToDurationConverter.class})
public class SignalFxMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SignalFxConfig signalfxConfig(SignalFxProperties props) {
        return new SignalFxPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public SignalFxMeterRegistry signalFxMeterRegistry(SignalFxConfig config, Clock clock) {
        return new SignalFxMeterRegistry(config, clock);
    }
}

