/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.jdbc;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import io.micrometer.spring.jdbc.DataSourcePoolMetrics;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, DataSourceAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, MeterRegistry.class})
@ConditionalOnBean(value={DataSource.class, MeterRegistry.class})
public class DataSourcePoolMetricsAutoConfiguration {

    @Configuration
    @ConditionalOnBean(value={DataSourcePoolMetadataProvider.class})
    static class DataSourcePoolMetadataMetricsConfiguration {
        private static final String DATASOURCE_SUFFIX = "dataSource";
        private final MeterRegistry registry;
        private final Collection<DataSourcePoolMetadataProvider> metadataProviders;

        DataSourcePoolMetadataMetricsConfiguration(MeterRegistry registry, Collection<DataSourcePoolMetadataProvider> metadataProviders) {
            this.registry = registry;
            this.metadataProviders = metadataProviders;
        }

        @Autowired
        public void bindDataSourcesToRegistry(Map<String, DataSource> dataSources) {
            dataSources.forEach(this::bindDataSourceToRegistry);
        }

        private void bindDataSourceToRegistry(String beanName, DataSource dataSource) {
            String dataSourceName = this.getDataSourceName(beanName);
            new DataSourcePoolMetrics(dataSource, this.metadataProviders, dataSourceName, Collections.emptyList()).bindTo(this.registry);
        }

        private String getDataSourceName(String beanName) {
            if (beanName.length() > DATASOURCE_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)DATASOURCE_SUFFIX)) {
                return beanName.substring(0, beanName.length() - DATASOURCE_SUFFIX.length());
            }
            return beanName;
        }
    }
}

