/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.datadog;

import io.micrometer.core.instrument.Clock;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.datadog.DatadogProperties;
import io.micrometer.spring.autoconfigure.export.datadog.DatadogPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={DatadogMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.datadog", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={DatadogProperties.class})
@Import(value={StringToDurationConverter.class})
public class DatadogMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DatadogConfig datadogConfig(DatadogProperties props) {
        return new DatadogPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public DatadogMeterRegistry datadogMeterRegistry(DatadogConfig config, Clock clock) {
        return new DatadogMeterRegistry(config, clock);
    }
}

