/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.stackdriver;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import io.micrometer.core.instrument.Clock;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.stackdriver.StackdriverProperties;
import io.micrometer.spring.autoconfigure.export.stackdriver.StackdriverPropertiesConfigAdapter;
import io.micrometer.stackdriver.StackdriverConfig;
import io.micrometer.stackdriver.StackdriverMeterRegistry;
import java.io.InputStream;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={StackdriverMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.stackdriver", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={StackdriverProperties.class})
@Import(value={StringToDurationConverter.class})
public class StackdriverMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public StackdriverConfig stackdriverConfig(StackdriverProperties props) {
        return new StackdriverPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public StackdriverMeterRegistry stackdriverMeterRegistry(StackdriverConfig config, StackdriverProperties props, Clock clock) {
        return StackdriverMeterRegistry.builder((StackdriverConfig)config).metricServiceSettings(() -> {
            MetricServiceSettings.Builder settingsBuilder = MetricServiceSettings.newBuilder();
            Resource credentials = props.getServiceAccountCredentials();
            if (credentials != null) {
                settingsBuilder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)ServiceAccountCredentials.fromStream((InputStream)credentials.getInputStream())));
            }
            return settingsBuilder.build();
        }).build();
    }
}

