/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web.tomcat;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.tomcat.TomcatMetrics;
import java.util.Collections;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class TomcatMetricsBinder
implements ApplicationListener<ApplicationReadyEvent> {
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> tags;

    public TomcatMetricsBinder(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public TomcatMetricsBinder(MeterRegistry meterRegistry, Iterable<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Manager manager = this.findManager((ApplicationContext)applicationContext);
        new TomcatMetrics(manager, this.tags).bindTo(this.meterRegistry);
    }

    private Manager findManager(ApplicationContext applicationContext) {
        Context context;
        EmbeddedServletContainer container;
        if (applicationContext instanceof EmbeddedWebApplicationContext && (container = ((EmbeddedWebApplicationContext)applicationContext).getEmbeddedServletContainer()) instanceof TomcatEmbeddedServletContainer && (context = this.findContext((TomcatEmbeddedServletContainer)container)) != null) {
            return context.getManager();
        }
        return null;
    }

    private Context findContext(TomcatEmbeddedServletContainer tomcatWebServer) {
        for (Container container : tomcatWebServer.getTomcat().getHost().findChildren()) {
            if (!(container instanceof Context)) continue;
            return (Context)container;
        }
        return null;
    }
}

