/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.appoptics;

import io.micrometer.appoptics.AppOpticsConfig;
import io.micrometer.appoptics.AppOpticsMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.appoptics.AppOpticsProperties;
import io.micrometer.spring.autoconfigure.export.appoptics.AppOpticsPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={AppOpticsMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.appoptics", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={AppOpticsProperties.class})
@Import(value={StringToDurationConverter.class})
public class AppOpticsMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AppOpticsConfig appOpticsConfig(AppOpticsProperties appOpticsProperties) {
        return new AppOpticsPropertiesConfigAdapter(appOpticsProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AppOpticsMeterRegistry appOpticsMeterRegistry(AppOpticsConfig config, Clock clock) {
        return new AppOpticsMeterRegistry(config, clock);
    }
}

