/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.humio;

import io.micrometer.core.instrument.Clock;
import io.micrometer.humio.HumioConfig;
import io.micrometer.humio.HumioMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.humio.HumioProperties;
import io.micrometer.spring.autoconfigure.export.humio.HumioPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={HumioMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.humio", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={HumioProperties.class})
@Import(value={StringToDurationConverter.class})
public class HumioMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HumioConfig humioConfig(HumioProperties props) {
        return new HumioPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public HumioMeterRegistry humioMeterRegistry(HumioConfig config, Clock clock) {
        return new HumioMeterRegistry(config, clock);
    }
}

