/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.internal.CumulativeHistogramLongTaskTimer;
import io.micrometer.core.instrument.observation.DefaultMeterObservationHandler;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public abstract class MeterRegistryCompatibilityKit {
    private final Object o = new Object();
    protected MeterRegistry registry;
    protected ObservationRegistry observationRegistry = ObservationRegistry.create();

    public abstract MeterRegistry registry();

    public abstract Duration step();

    @BeforeEach
    void setup() {
        this.registry = this.registry();
        this.observationRegistry.observationConfig().observationHandler((ObservationHandler)new DefaultMeterObservationHandler(this.registry));
    }

    @Test
    @DisplayName(value="compatibility test provides a non-null registry instance")
    void registryIsNotNull() {
        Assertions.assertThat((Object)this.registry).isNotNull();
    }

    @Test
    @DisplayName(value="meters with the same name and tags are registered once")
    void uniqueMeters() {
        this.registry.counter("foo", new String[0]);
        this.registry.counter("foo", new String[0]);
        Assertions.assertThat((int)this.registry.get("foo").meters().size()).isEqualTo(1);
    }

    @Test
    @DisplayName(value="find meters by name and class type matching a subset of their tags")
    void findMeters() {
        Counter c1 = this.registry.counter("foo", new String[]{"k", "v"});
        Counter c2 = this.registry.counter("bar", new String[]{"k", "v", "k2", "v"});
        Assertions.assertThat((Object)this.registry.get("foo").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c1);
        Assertions.assertThat((Object)this.registry.get("bar").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c2);
    }

    @Test
    @DisplayName(value="find meters by name and type matching a subset of their tags")
    void findMetersByType() {
        Counter c1 = this.registry.counter("foo", new String[]{"k", "v"});
        Counter c2 = this.registry.counter("bar", new String[]{"k", "v", "k2", "v"});
        Assertions.assertThat((Object)this.registry.get("foo").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c1);
        Assertions.assertThat((Object)this.registry.get("bar").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c2);
    }

    @Test
    @DisplayName(value="find meters by name and value")
    void findMetersByValue() {
        Counter c = this.registry.counter("counter", new String[0]);
        c.increment();
        Timer t = this.registry.timer("timer", new String[0]);
        t.record(10L, TimeUnit.NANOSECONDS);
        MockClock.clock((MeterRegistry)this.registry).add(this.step());
        Assertions.assertThat((double)this.registry.get("counter").counter().count()).isEqualTo(1.0);
        Assertions.assertThat((long)this.registry.get("timer").timer().count()).isEqualTo(1L);
        Assertions.assertThat((double)this.registry.get("timer").timer().totalTime(TimeUnit.NANOSECONDS)).isEqualTo(10.0);
    }

    @Test
    @DisplayName(value="common tags are added to every measurement")
    void addCommonTags() {
        this.registry.config().commonTags(new String[]{"k", "v"});
        Counter c = this.registry.counter("foo", new String[0]);
        Assertions.assertThat((Object)this.registry.get("foo").tags(new String[]{"k", "v"}).counter()).isSameAs((Object)c);
        Assertions.assertThat((Iterable)c.getId().getTagsAsIterable()).hasSize(1);
    }

    @Test
    @DisplayName(value="original and convention names are preserved for custom meter types")
    void aTaleOfTwoNames() {
        AtomicInteger n = new AtomicInteger(1);
        this.registry.more().counter("my.counter", Collections.emptyList(), (Number)n);
        this.registry.get("my.counter").functionCounter();
    }

    @Test
    @DisplayName(value="function timers respect the base unit of an underlying registry")
    void functionTimerUnits() {
        this.registry.more().timer("function.timer", Collections.emptyList(), this.o, o2 -> 1L, o2 -> 1.0, TimeUnit.MILLISECONDS);
        FunctionTimer ft = this.registry.get("function.timer").functionTimer();
        MockClock.clock((MeterRegistry)this.registry).add(this.step());
        Assertions.assertThat((Iterable)ft.measure()).anySatisfy(ms -> {
            TimeUnit baseUnit = TimeUnit.valueOf(Objects.requireNonNull(ft.getId().getBaseUnit()).toUpperCase());
            Assertions.assertThat((Comparable)ms.getStatistic()).isEqualTo((Object)Statistic.TOTAL_TIME);
            Assertions.assertThat((double)TimeUtils.convert((double)ms.getValue(), (TimeUnit)baseUnit, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(1.0);
        });
    }

    @Test
    @DisplayName(value="meters with synthetics can be removed without causing deadlocks")
    void removeMeterWithSynthetic() {
        Timer timer = Timer.builder((String)"my.timer").publishPercentiles(new double[]{0.95}).serviceLevelObjectives(new Duration[]{Duration.ofMillis(10L)}).register(this.registry);
        this.registry.remove((Meter)timer);
    }

    private void assertHistogramBuckets(CountAtBucket[] countAtBuckets) {
        this.assertHistogramBuckets(countAtBuckets, null);
    }

    private void assertHistogramBuckets(CountAtBucket[] countAtBuckets, TimeUnit timeUnit) {
        Assertions.assertThat((Object[])countAtBuckets).extracting(c -> this.getCount((CountAtBucket)c, timeUnit)).contains((Object[])new Double[]{5.0, 50.0, 95.0});
        Assertions.assertThat((Object[])countAtBuckets).satisfiesAnyOf(new ThrowingConsumer[]{bucketCounts -> Assertions.assertThat(Arrays.stream(bucketCounts).filter(countAtBucket -> Arrays.asList(5.0, 50.0, 95.0).contains(this.getCount((CountAtBucket)countAtBucket, timeUnit)))).extracting(CountAtBucket::count).containsExactly((Object[])new Double[]{0.0, 1.0, 3.0}), bucketCounts -> {
            Assertions.assertThat((double)this.nonCumulativeBucketCountForRange((CountAtBucket[])bucketCounts, timeUnit, 0.0, 5.0)).isEqualTo(0.0);
            Assertions.assertThat((double)this.nonCumulativeBucketCountForRange((CountAtBucket[])bucketCounts, timeUnit, 5.0, 50.0)).isEqualTo(1.0);
            Assertions.assertThat((double)this.nonCumulativeBucketCountForRange((CountAtBucket[])bucketCounts, timeUnit, 50.0, 95.0)).isEqualTo(2.0);
        }});
    }

    private double getCount(CountAtBucket countAtBucket, TimeUnit timeUnit) {
        return timeUnit != null ? countAtBucket.bucket(timeUnit) : countAtBucket.bucket();
    }

    private double nonCumulativeBucketCountForRange(CountAtBucket[] countAtBuckets, TimeUnit timeUnit, double exclusiveMinBucket, double inclusiveMaxBucket) {
        double count = 0.0;
        for (CountAtBucket countAtBucket : countAtBuckets) {
            double c = this.getCount(countAtBucket, timeUnit);
            if (!(c > exclusiveMinBucket) || !(c <= inclusiveMaxBucket)) continue;
            count += countAtBucket.count();
        }
        return count;
    }

    @DisplayName(value="timers")
    @Nested
    class TimerTck {
        TimerTck() {
        }

        @DisplayName(value="autocloseable sample")
        @ParameterizedTest(name="when outcome is \"{0}\"")
        @CsvSource(value={"success", "error"})
        void closeable(String outcome) {
            try (Timer.ResourceSample sample = (Timer.ResourceSample)((Timer.ResourceSample)Timer.resource((MeterRegistry)MeterRegistryCompatibilityKit.this.registry, (String)"requests").description("This is an operation")).publishPercentileHistogram();){
                try {
                    if (outcome.equals("error")) {
                        throw new IllegalArgumentException("boom");
                    }
                    sample.tag("outcome", "success");
                }
                catch (Throwable t) {
                    sample.tag("outcome", "error");
                }
            }
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            Assertions.assertThat((long)MeterRegistryCompatibilityKit.this.registry.get("requests").tag("outcome", outcome).timer().count()).isEqualTo(1L);
        }

        @DisplayName(value="record callable")
        @Test
        void recordCallable() throws Exception {
            MeterRegistryCompatibilityKit.this.registry.timer("timer", new String[0]).recordCallable(() -> "");
        }

        @Test
        @DisplayName(value="total time and count are preserved for a single timing")
        void record() {
            Timer t = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            t.record(42L, TimeUnit.MILLISECONDS);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)42.0, (double)t.totalTime(TimeUnit.MILLISECONDS), (double)1.0E-12)});
        }

        @Test
        @DisplayName(value="record durations")
        void recordDuration() {
            Timer t = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            t.record(Duration.ofMillis(42L));
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)42.0, (double)t.totalTime(TimeUnit.MILLISECONDS), (double)1.0E-12)});
        }

        @Test
        @DisplayName(value="negative times are discarded by the Timer")
        void recordNegative() {
            Timer t = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            t.record(-42L, TimeUnit.MILLISECONDS);
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
        }

        @Test
        @DisplayName(value="zero times contribute to the count of overall events but do not add to total time")
        void recordZero() {
            Timer t = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            t.record(0L, TimeUnit.MILLISECONDS);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)t.totalTime(TimeUnit.NANOSECONDS))});
        }

        @Test
        @DisplayName(value="record a runnable task")
        void recordWithRunnable() {
            Timer t = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            Runnable r = () -> MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(10L, TimeUnit.NANOSECONDS);
            try {
                t.record(r);
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            }
            catch (Throwable throwable) {
                org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
                throw throwable;
            }
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        @DisplayName(value="record supplier")
        void recordWithSupplier() {
            Timer t = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            String expectedResult = "response";
            Supplier<String> supplier = () -> {
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(10L, TimeUnit.NANOSECONDS);
                return expectedResult;
            };
            try {
                String supplierResult = (String)t.record(supplier);
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)supplierResult);
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            }
            catch (Throwable throwable) {
                org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
                throw throwable;
            }
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        @DisplayName(value="wrap supplier")
        void wrapSupplier() {
            Timer timer = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            String expectedResult = "response";
            Supplier<String> supplier = () -> {
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(10L, TimeUnit.NANOSECONDS);
                return expectedResult;
            };
            try {
                Supplier wrappedSupplier = timer.wrap(supplier);
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, wrappedSupplier.get());
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            }
            catch (Throwable throwable) {
                org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)timer.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)timer.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
                throw throwable;
            }
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)timer.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)timer.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
        }

        @Test
        @DisplayName(value="record with stateful Sample instance")
        void recordWithSample() {
            Timer timer = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            Timer.Sample sample = Timer.start((MeterRegistry)MeterRegistryCompatibilityKit.this.registry);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(10L, TimeUnit.NANOSECONDS);
            sample.stop(timer);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)timer.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)timer.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
        }

        @Test
        @DisplayName(value="record with stateful Observation instance")
        void recordWithObservation() {
            Observation observation = Observation.createNotStarted((String)"myObservation", (ObservationRegistry)MeterRegistryCompatibilityKit.this.observationRegistry).lowCardinalityKeyValue("staticTag", "42").start();
            observation.lowCardinalityKeyValue("dynamicTag", "24");
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(1L, TimeUnit.SECONDS);
            observation.event(Observation.Event.of((String)"testEvent", (String)"event for testing"));
            LongTaskTimer longTaskTimer = MeterRegistryCompatibilityKit.this.registry.more().longTaskTimer("myObservation.active", new String[]{"staticTag", "42"});
            Assertions.assertThat((int)longTaskTimer.activeTasks()).isEqualTo(1);
            observation.stop();
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            Assertions.assertThat((int)longTaskTimer.activeTasks()).isEqualTo(0);
            Timer timer = MeterRegistryCompatibilityKit.this.registry.timer("myObservation", new String[]{"error", "none", "staticTag", "42", "dynamicTag", "24"});
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)timer.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)1.0E-12)});
            Counter counter = MeterRegistryCompatibilityKit.this.registry.counter("myObservation.testEvent", new String[]{"staticTag", "42", "dynamicTag", "24"});
            Assertions.assertThat((double)counter.count()).isEqualTo(1.0);
        }

        @Test
        @DisplayName(value="record with stateful Observation and Scope instances")
        void recordWithObservationAndScope() {
            Observation observation = Observation.start((String)"myObservation", (ObservationRegistry)MeterRegistryCompatibilityKit.this.observationRegistry);
            try (Observation.Scope scope = observation.openScope();){
                Assertions.assertThat((Object)scope.getCurrentObservation()).isSameAs((Object)observation);
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(10L, TimeUnit.NANOSECONDS);
                observation.event(Observation.Event.of((String)"testEvent", (String)"event for testing"));
            }
            observation.stop();
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            Timer timer = MeterRegistryCompatibilityKit.this.registry.timer("myObservation", new String[]{"error", "none"});
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)timer.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)timer.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
            Counter counter = MeterRegistryCompatibilityKit.this.registry.counter("myObservation.testEvent", new String[0]);
            Assertions.assertThat((double)counter.count()).isEqualTo(1.0);
        }

        @Test
        void recordMax() {
            Timer timer = MeterRegistryCompatibilityKit.this.registry.timer("my.timer", new String[0]);
            timer.record(10L, TimeUnit.MILLISECONDS);
            timer.record(1L, TimeUnit.SECONDS);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            Assertions.assertThat((double)timer.max(TimeUnit.SECONDS)).isEqualTo(1.0);
            Assertions.assertThat((double)timer.max(TimeUnit.MILLISECONDS)).isEqualTo(1000.0);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(Duration.ofMillis(MeterRegistryCompatibilityKit.this.step().toMillis() * (long)DistributionStatisticConfig.DEFAULT.getBufferLength().intValue()));
            Assertions.assertThat((double)timer.max(TimeUnit.SECONDS)).isEqualTo(0.0);
        }

        @Test
        @DisplayName(value="callable task that throws exception is still recorded")
        void recordCallableException() {
            Timer t = MeterRegistryCompatibilityKit.this.registry.timer("myTimer", new String[0]);
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> t.recordCallable(() -> {
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(10L, TimeUnit.NANOSECONDS);
                throw new Exception("uh oh");
            }));
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
        }

        @Test
        void percentiles() {
            Timer t = Timer.builder((String)"my.timer").publishPercentiles(new double[]{1.0}).register(MeterRegistryCompatibilityKit.this.registry);
            t.record(1L, TimeUnit.MILLISECONDS);
            Assertions.assertThat((double)t.percentile(1.0, TimeUnit.MILLISECONDS)).isEqualTo(1.0, Offset.offset((Number)0.3));
            Assertions.assertThat((double)t.percentile(0.5, TimeUnit.MILLISECONDS)).isNaN();
        }

        @Test
        void histogramCounts() {
            Timer t = Timer.builder((String)"my.timer").serviceLevelObjectives(new Duration[]{Duration.ofMillis(1L)}).register(MeterRegistryCompatibilityKit.this.registry);
            Duration halfStep = MeterRegistryCompatibilityKit.this.step().dividedBy(2L);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(halfStep);
            t.record(1L, TimeUnit.MILLISECONDS);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(halfStep);
            Assertions.assertThat((double)t.histogramCountAtValue((long)TimeUtils.millisToUnit((double)1.0, (TimeUnit)TimeUnit.NANOSECONDS))).isEqualTo(1.0);
            Assertions.assertThat((double)t.histogramCountAtValue(1L)).isNaN();
        }

        @Test
        void histogramCountsPublishPercentileHistogramAndSlos() {
            Timer timer = Timer.builder((String)"my.timer").serviceLevelObjectives(new Duration[]{Duration.ofMillis(5L), Duration.ofMillis(50L), Duration.ofMillis(95L)}).publishPercentileHistogram().register(MeterRegistryCompatibilityKit.this.registry);
            Duration halfStep = MeterRegistryCompatibilityKit.this.step().dividedBy(2L);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(halfStep);
            for (int val : new int[]{22, 55, 66, 98}) {
                timer.record(Duration.ofMillis(val));
            }
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(halfStep);
            HistogramSnapshot snapshot = timer.takeSnapshot();
            CountAtBucket[] countAtBuckets = snapshot.histogramCounts();
            MeterRegistryCompatibilityKit.this.assertHistogramBuckets(countAtBuckets, TimeUnit.MILLISECONDS);
        }
    }

    @DisplayName(value="long task timers")
    @Nested
    class LongTaskTimerTck {
        LongTaskTimerTck() {
        }

        @Test
        @DisplayName(value="total time is preserved for a single timing")
        void record() {
            LongTaskTimer t = MeterRegistryCompatibilityKit.this.registry.more().longTaskTimer("my.timer", new String[0]);
            LongTaskTimer.Sample sample = t.start();
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(10L, TimeUnit.NANOSECONDS);
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.duration(TimeUnit.NANOSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.01, (double)t.duration(TimeUnit.MICROSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)sample.duration(TimeUnit.NANOSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.01, (double)sample.duration(TimeUnit.MICROSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)t.activeTasks())});
            Assertions.assertThat((Iterable)t.measure()).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{measurement -> Assertions.assertThat((Object)measurement).satisfies(new ThrowingConsumer[]{m -> {
                Assertions.assertThat((double)m.getValue()).isEqualTo(1.0);
                Assertions.assertThat((Comparable)m.getStatistic()).isSameAs((Object)Statistic.ACTIVE_TASKS);
            }}), measurement -> Assertions.assertThat((Object)measurement).satisfies(new ThrowingConsumer[]{m -> {
                Assertions.assertThat((double)m.getValue()).isEqualTo(TimeUtils.convert((double)10.0, (TimeUnit)TimeUnit.NANOSECONDS, (TimeUnit)t.baseTimeUnit()));
                Assertions.assertThat((Comparable)m.getStatistic()).isSameAs((Object)Statistic.DURATION);
            }})});
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(10L, TimeUnit.NANOSECONDS);
            sample.stop();
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)t.duration(TimeUnit.NANOSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((double)-1.0, (double)sample.duration(TimeUnit.NANOSECONDS)), () -> org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)t.activeTasks())});
        }

        @Test
        @DisplayName(value="supports sending the Nth percentile active task duration")
        void percentiles() {
            LongTaskTimer t = LongTaskTimer.builder((String)"my.timer").publishPercentiles(new double[]{0.5, 0.7, 0.91, 0.999, 1.0}).register(MeterRegistryCompatibilityKit.this.registry);
            List<Integer> samples = Arrays.asList(48, 42, 40, 35, 22, 16, 13, 8, 6, 4, 2);
            int prior = samples.get(0);
            for (Integer value : samples) {
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add((long)(prior - value), TimeUnit.SECONDS);
                t.start();
                prior = value;
            }
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add((long)samples.get(samples.size() - 1).intValue(), TimeUnit.SECONDS);
            Assertions.assertThat((int)t.activeTasks()).isEqualTo(11);
            ValueAtPercentile[] percentiles = t.takeSnapshot().percentileValues();
            Assertions.assertThat((double)percentiles[0].percentile()).isEqualTo(0.5);
            Assertions.assertThat((double)percentiles[0].value(TimeUnit.SECONDS)).isEqualTo(16.0);
            Assertions.assertThat((double)percentiles[1].percentile()).isEqualTo(0.7);
            Assertions.assertThat((double)percentiles[1].value(TimeUnit.SECONDS)).isEqualTo(37.0, Assertions.within((Double)0.001));
            Assertions.assertThat((double)percentiles[2].percentile()).isEqualTo(0.91);
            Assertions.assertThat((double)percentiles[2].value(TimeUnit.SECONDS)).isEqualTo(47.5, Assertions.within((Double)0.1));
            Assertions.assertThat((double)percentiles[3].percentile()).isEqualTo(0.999);
            Assertions.assertThat((double)percentiles[3].value(TimeUnit.SECONDS)).isEqualTo(48.0, Assertions.within((Double)0.1));
            Assertions.assertThat((double)percentiles[4].percentile()).isEqualTo(1.0);
            Assertions.assertThat((double)percentiles[4].value(TimeUnit.SECONDS)).isEqualTo(48.0);
        }

        @Test
        @DisplayName(value="supports sending histograms of active task duration")
        void histogram() {
            LongTaskTimer t = LongTaskTimer.builder((String)"my.timer").serviceLevelObjectives(new Duration[]{Duration.ofSeconds(10L), Duration.ofSeconds(40L), Duration.ofMinutes(1L)}).register(MeterRegistryCompatibilityKit.this.registry);
            List<Integer> samples = Arrays.asList(48, 42, 40, 35, 22, 16, 13, 8, 6, 4, 2);
            int prior = samples.get(0);
            for (Integer value : samples) {
                MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add((long)(prior - value), TimeUnit.SECONDS);
                t.start();
                prior = value;
            }
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add((long)samples.get(samples.size() - 1).intValue(), TimeUnit.SECONDS);
            CountAtBucket[] countAtBuckets = t.takeSnapshot().histogramCounts();
            Assertions.assertThat((double)countAtBuckets[0].bucket(TimeUnit.SECONDS)).isEqualTo(10.0);
            Assertions.assertThat((double)countAtBuckets[0].count()).isEqualTo(4.0);
            Assertions.assertThat((double)countAtBuckets[1].bucket(TimeUnit.SECONDS)).isEqualTo(40.0);
            Assertions.assertThat((double)countAtBuckets[1].count()).isEqualTo(9.0);
            Assertions.assertThat((double)countAtBuckets[2].bucket(TimeUnit.MINUTES)).isEqualTo(1.0);
            Assertions.assertThat((double)countAtBuckets[2].count()).isEqualTo(11.0);
        }

        @Test
        @DisplayName(value="attributes from @Timed annotation apply to builder")
        void timedAnnotation() {
            Timed timed = AnnotationHolder.class.getAnnotation(Timed.class);
            LongTaskTimer ltt = LongTaskTimer.builder((Timed)timed).register(MeterRegistryCompatibilityKit.this.registry);
            Meter.Id id = ltt.getId();
            Assertions.assertThat((String)id.getName()).isEqualTo("my.name");
            Assertions.assertThat((List)id.getTags()).containsExactly((Object[])new Tag[]{Tag.of((String)"a", (String)"tag")});
            Assertions.assertThat((String)id.getDescription()).isEqualTo("some description");
            if (ltt instanceof CumulativeHistogramLongTaskTimer) {
                Assertions.assertThat((Object[])ltt.takeSnapshot().histogramCounts()).isNotEmpty();
            }
        }

        @Timed(value="my.name", longTask=true, extraTags={"a", "tag"}, description="some description", histogram=true)
        class AnnotationHolder {
            AnnotationHolder() {
            }
        }
    }

    @DisplayName(value="gauges")
    @Nested
    class GaugeTck {
        GaugeTck() {
        }

        @Test
        @DisplayName(value="gauges attached to a number are updated when their values are observed")
        void numericGauge() {
            AtomicInteger n = (AtomicInteger)MeterRegistryCompatibilityKit.this.registry.gauge("my.gauge", (Number)new AtomicInteger());
            n.set(1);
            Gauge g = MeterRegistryCompatibilityKit.this.registry.get("my.gauge").gauge();
            Assertions.assertThat((double)g.value()).isEqualTo(1.0);
            n.set(2);
            Assertions.assertThat((double)g.value()).isEqualTo(2.0);
        }

        @Test
        @DisplayName(value="gauges attached to an object are updated when their values are observed")
        void objectGauge() {
            List list = (List)MeterRegistryCompatibilityKit.this.registry.gauge("my.gauge", Collections.emptyList(), new ArrayList(), List::size);
            list.addAll(Arrays.asList("a", "b"));
            Gauge g = MeterRegistryCompatibilityKit.this.registry.get("my.gauge").gauge();
            Assertions.assertThat((double)g.value()).isEqualTo(2.0);
        }

        @Test
        @DisplayName(value="gauges can be directly associated with collection size")
        void collectionSizeGauge() {
            List list = (List)MeterRegistryCompatibilityKit.this.registry.gaugeCollectionSize("my.gauge", Collections.emptyList(), new ArrayList());
            list.addAll(Arrays.asList("a", "b"));
            Gauge g = MeterRegistryCompatibilityKit.this.registry.get("my.gauge").gauge();
            Assertions.assertThat((double)g.value()).isEqualTo(2.0);
        }

        @Test
        @DisplayName(value="gauges can be directly associated with map entry size")
        void mapSizeGauge() {
            Map map = MeterRegistryCompatibilityKit.this.registry.gaugeMapSize("my.gauge", Collections.emptyList(), new HashMap());
            map.put("a", 1);
            Gauge g = MeterRegistryCompatibilityKit.this.registry.get("my.gauge").gauge();
            Assertions.assertThat((double)g.value()).isEqualTo(1.0);
        }

        @Test
        @DisplayName(value="gauges that reference an object that is garbage collected report NaN")
        void garbageCollectedSourceObject() {
            MeterRegistryCompatibilityKit.this.registry.gauge("my.gauge", Collections.emptyList(), (Object)null, Map::size);
            Assertions.assertThat((double)MeterRegistryCompatibilityKit.this.registry.get("my.gauge").gauge().value()).matches(val -> val == null || Double.isNaN(val) || val == 0.0);
        }

        @Test
        @DisplayName(value="strong reference gauges")
        void strongReferenceGauges() {
            Gauge.builder((String)"weak.ref", (Object)1.0, n -> n).register(MeterRegistryCompatibilityKit.this.registry);
            Gauge.builder((String)"strong.ref", (Object)1.0, n -> n).strongReference(true).register(MeterRegistryCompatibilityKit.this.registry);
            System.gc();
            Assertions.assertThat((double)MeterRegistryCompatibilityKit.this.registry.get("weak.ref").gauge().value()).isNaN();
            Assertions.assertThat((double)MeterRegistryCompatibilityKit.this.registry.get("strong.ref").gauge().value()).isEqualTo(1.0);
        }
    }

    @DisplayName(value="distribution summaries")
    @Nested
    class DistributionSummaryTck {
        DistributionSummaryTck() {
        }

        @Test
        @DisplayName(value="multiple recordings are maintained")
        void record() {
            DistributionSummary ds = MeterRegistryCompatibilityKit.this.registry.summary("my.summary", new String[0]);
            ds.record(10.0);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            ds.count();
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)ds.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)ds.totalAmount())});
            ds.record(10.0);
            ds.record(10.0);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertTrue((ds.count() >= 2L ? 1 : 0) != 0), () -> org.junit.jupiter.api.Assertions.assertTrue((ds.totalAmount() >= 20.0 ? 1 : 0) != 0)});
        }

        @Test
        @DisplayName(value="negative quantities are ignored")
        void recordNegative() {
            DistributionSummary ds = MeterRegistryCompatibilityKit.this.registry.summary("my.summary", new String[0]);
            ds.record(-10.0);
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)ds.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)ds.totalAmount())});
        }

        @Test
        @DisplayName(value="record zero")
        void recordZero() {
            DistributionSummary ds = MeterRegistryCompatibilityKit.this.registry.summary("my.summary", new String[0]);
            ds.record(0.0);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)ds.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)ds.totalAmount())});
        }

        @Test
        @DisplayName(value="scale samples by a fixed factor")
        void scale() {
            DistributionSummary ds = DistributionSummary.builder((String)"my.summary").scale(2.0).register(MeterRegistryCompatibilityKit.this.registry);
            ds.record(1.0);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            Assertions.assertThat((double)ds.totalAmount()).isEqualTo(2.0);
        }

        @Test
        void percentiles() {
            DistributionSummary s = DistributionSummary.builder((String)"my.summary").publishPercentiles(new double[]{1.0}).register(MeterRegistryCompatibilityKit.this.registry);
            s.record(1.0);
            Assertions.assertThat((double)s.percentile(1.0)).isEqualTo(1.0, Offset.offset((Number)0.3));
            Assertions.assertThat((double)s.percentile(0.5)).isNaN();
        }

        @Test
        void histogramCounts() {
            DistributionSummary s = DistributionSummary.builder((String)"my.summmary").serviceLevelObjectives(new double[]{1.0}).register(MeterRegistryCompatibilityKit.this.registry);
            Duration halfStep = MeterRegistryCompatibilityKit.this.step().dividedBy(2L);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(halfStep);
            s.record(1.0);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(halfStep);
            Assertions.assertThat((double)s.histogramCountAtValue(1L)).isEqualTo(1.0);
            Assertions.assertThat((double)s.histogramCountAtValue(2L)).isNaN();
        }

        @Test
        void histogramCountsPublishPercentileHistogramAndSlos() {
            DistributionSummary summary = DistributionSummary.builder((String)"my.summmary").serviceLevelObjectives(new double[]{5.0, 50.0, 95.0}).publishPercentileHistogram().register(MeterRegistryCompatibilityKit.this.registry);
            Duration halfStep = MeterRegistryCompatibilityKit.this.step().dividedBy(2L);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(halfStep);
            for (int val : new int[]{22, 55, 66, 98}) {
                summary.record((double)val);
            }
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(halfStep);
            HistogramSnapshot snapshot = summary.takeSnapshot();
            CountAtBucket[] countAtBuckets = snapshot.histogramCounts();
            MeterRegistryCompatibilityKit.this.assertHistogramBuckets(countAtBuckets);
        }
    }

    @DisplayName(value="counters")
    @Nested
    class CounterTck {
        CounterTck() {
        }

        @DisplayName(value="multiple increments are maintained")
        @Test
        void increment() {
            Counter c = MeterRegistryCompatibilityKit.this.registry.counter("myCounter", new String[0]);
            c.increment();
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            Assertions.assertThat((double)c.count()).isEqualTo(1.0, Assertions.offset((Double)1.0E-12));
            c.increment();
            c.increment();
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            Assertions.assertThat((double)c.count()).isGreaterThanOrEqualTo(2.0);
        }

        @Test
        @DisplayName(value="increment by a non-negative amount")
        void incrementAmount() {
            Counter c = MeterRegistryCompatibilityKit.this.registry.counter("myCounter", new String[0]);
            c.increment(2.0);
            c.increment(0.0);
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            org.junit.jupiter.api.Assertions.assertEquals((double)2.0, (double)c.count());
        }

        @Test
        @DisplayName(value="function-tracking counter increments by change in a monotonically increasing function when observed")
        void functionTrackingCounter() {
            AtomicLong n = new AtomicLong();
            MeterRegistryCompatibilityKit.this.registry.more().counter("tracking", Collections.emptyList(), (Number)n);
            n.incrementAndGet();
            MockClock.clock((MeterRegistry)MeterRegistryCompatibilityKit.this.registry).add(MeterRegistryCompatibilityKit.this.step());
            MeterRegistryCompatibilityKit.this.registry.forEachMeter(Meter::measure);
            Assertions.assertThat((double)MeterRegistryCompatibilityKit.this.registry.get("tracking").functionCounter().count()).isEqualTo(1.0);
        }
    }
}

