/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.ipc.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.micrometer.core.ipc.http.HttpSender;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import ru.lanwen.wiremock.ext.WiremockResolver;

@ExtendWith(value={WiremockResolver.class})
public abstract class HttpSenderCompatibilityKit {
    protected HttpSender httpSender;

    public abstract HttpSender httpClient();

    @BeforeEach
    void setup() {
        this.httpSender = this.httpClient();
    }

    @Test
    @DisplayName(value="compatibility test provides a non-null http client instance")
    void httpSenderIsNotNull() {
        Assertions.assertThat((Object)this.httpSender).isNotNull();
    }

    @ParameterizedTest
    @DisplayName(value="successfully send a request with NO body and receive a response with NO body")
    @EnumSource(value=HttpSender.Method.class)
    void successfulRequestSentWithNoBody(HttpSender.Method method, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/metrics")));
        HttpSender.Response response = this.httpSender.newRequest(server.baseUrl() + "/metrics").withMethod(method).send();
        Assertions.assertThat((int)response.code()).isEqualTo(200);
        Assertions.assertThat((String)response.body()).isEqualTo("<no response body>");
        server.verify(WireMock.requestMadeFor(request -> MatchResult.aggregate((MatchResult[])new MatchResult[]{MatchResult.of((boolean)request.getMethod().getName().equals(method.name())), MatchResult.of((boolean)request.getUrl().equals("/metrics"))})));
    }

    @ParameterizedTest
    @DisplayName(value="successfully send a request with a body and receive a response with a body")
    @EnumSource(value=HttpSender.Method.class, names={"POST", "PUT"})
    void successfulRequestSentWithBody(HttpSender.Method method, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/metrics")).willReturn(WireMock.ok((String)"a body")));
        HttpSender.Response response = this.httpSender.newRequest(server.baseUrl() + "/metrics").withMethod(method).accept("customAccept").withContent("custom/type", "this is a line").send();
        Assertions.assertThat((int)response.code()).isEqualTo(200);
        Assertions.assertThat((String)response.body()).isEqualTo("a body");
        server.verify(WireMock.requestMadeFor(request -> MatchResult.aggregate((MatchResult[])new MatchResult[]{MatchResult.of((boolean)request.getMethod().getName().equals(method.name())), MatchResult.of((boolean)request.getUrl().equals("/metrics"))})).withHeader("Accept", WireMock.equalTo((String)"customAccept")).withHeader("Content-Type", WireMock.containing((String)"custom/type")).withRequestBody((ContentPattern)WireMock.equalTo((String)"this is a line")));
    }

    @ParameterizedTest
    @DisplayName(value="receive an error response")
    @EnumSource(value=HttpSender.Method.class)
    void errorResponseReceived(HttpSender.Method method, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/metrics")).willReturn(WireMock.badRequest().withBody("Error processing metrics")));
        HttpSender.Response response = this.httpSender.newRequest(server.baseUrl() + "/metrics").withMethod(method).send();
        Assertions.assertThat((int)response.code()).isEqualTo(400);
        if (!HttpSender.Method.HEAD.equals((Object)method)) {
            Assertions.assertThat((String)response.body()).isEqualTo("Error processing metrics");
        } else {
            Assertions.assertThat((String)response.body()).isEqualTo("<no response body>");
        }
    }

    @ParameterizedTest
    @EnumSource(value=HttpSender.Method.class)
    void basicAuth(HttpSender.Method method, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/metrics")).willReturn(WireMock.unauthorized()));
        HttpSender.Response response = this.httpSender.newRequest(server.baseUrl() + "/metrics").withMethod(method).withBasicAuthentication("superuser", "superpassword").send();
        Assertions.assertThat((int)response.code()).isEqualTo(401);
        server.verify(WireMock.requestMadeFor(request -> MatchResult.aggregate((MatchResult[])new MatchResult[]{MatchResult.of((boolean)request.getMethod().getName().equals(method.name())), MatchResult.of((boolean)request.getUrl().equals("/metrics"))})).withBasicAuth(new BasicCredentials("superuser", "superpassword")));
    }

    @ParameterizedTest
    @EnumSource(value=HttpSender.Method.class)
    void customHeader(HttpSender.Method method, @WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/metrics")).willReturn(WireMock.unauthorized()));
        HttpSender.Response response = this.httpSender.newRequest(server.baseUrl() + "/metrics").withMethod(method).withHeader("customHeader", "customHeaderValue").send();
        Assertions.assertThat((int)response.code()).isEqualTo(401);
        server.verify(WireMock.requestMadeFor(request -> MatchResult.aggregate((MatchResult[])new MatchResult[]{MatchResult.of((boolean)request.getMethod().getName().equals(method.name())), MatchResult.of((boolean)request.getUrl().equals("/metrics"))})).withHeader("customHeader", WireMock.equalTo((String)"customHeaderValue")));
    }

    @Test
    void authenticationHeader(@WiremockResolver.Wiremock WireMockServer server) throws Throwable {
        server.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/metrics")).willReturn(WireMock.unauthorized()));
        HttpSender.Response response = this.httpSender.newRequest(server.baseUrl() + "/metrics").withMethod(HttpSender.Method.POST).withAuthentication("Bearer", "mF_9.B5f-4.1JqM").send();
        Assertions.assertThat((int)response.code()).isEqualTo(401);
        server.verify(WireMock.requestMadeFor(request -> MatchResult.aggregate((MatchResult[])new MatchResult[]{MatchResult.of((boolean)request.getMethod().getName().equals("POST")), MatchResult.of((boolean)request.getUrl().equals("/metrics"))})).withHeader("Authorization", WireMock.equalTo((String)"Bearer mF_9.B5f-4.1JqM")));
    }
}

