/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.step;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

@Incubating(since="1.11.1")
public class PollingAwareMockStepClock
implements Clock {
    private final Duration step;
    private long timeNanos = (long)TimeUtils.millisToUnit((double)1.0, (TimeUnit)TimeUnit.NANOSECONDS);

    public PollingAwareMockStepClock(StepRegistryConfig stepRegistryConfig) {
        this.step = stepRegistryConfig.step();
    }

    public long wallTime() {
        return TimeUnit.MILLISECONDS.convert(this.timeNanos, TimeUnit.NANOSECONDS);
    }

    public long monotonicTime() {
        return this.timeNanos;
    }

    public long add(Duration duration, StepMeterRegistry stepMeterRegistry) {
        this.addTimeWithRolloverOnStepStart(duration, stepMeterRegistry);
        return this.timeNanos;
    }

    private void addTimeWithRolloverOnStepStart(Duration timeToAdd, StepMeterRegistry stepMeterRegistry) {
        long stepMillis = this.step.toMillis();
        while (timeToAdd.toMillis() >= stepMillis) {
            long boundaryForNextStep = (this.timeNanos / stepMillis + 1L) * stepMillis;
            Duration timeToNextStep = Duration.ofMillis(boundaryForNextStep - this.timeNanos);
            if (timeToAdd.toMillis() < timeToNextStep.toMillis()) continue;
            timeToAdd = timeToAdd.minus(timeToNextStep);
            this.addTimeToClock(timeToNextStep);
            stepMeterRegistry.pollMetersToRollover();
        }
        this.addTimeToClock(timeToAdd);
    }

    private void addTimeToClock(Duration duration) {
        this.timeNanos += duration.toNanos();
    }
}

