/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.InstrumentationTimingVerificationTests;
import io.micrometer.core.instrument.InstrumentationVerificationTests;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.tck.TestObservationRegistry;
import io.micrometer.observation.transport.RequestReplySenderContext;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@WireMockTest
@Incubating(since="1.8.8")
public abstract class HttpClientTimingInstrumentationVerificationTests<CLIENT>
extends InstrumentationTimingVerificationTests {
    @Nullable
    private CLIENT createdClient;

    protected abstract CLIENT clientInstrumentedWithMetrics();

    @Nullable
    protected abstract CLIENT clientInstrumentedWithObservations();

    private CLIENT instrumentedClient(InstrumentationVerificationTests.TestType testType) {
        if (this.createdClient != null) {
            return this.createdClient;
        }
        this.createdClient = testType == InstrumentationVerificationTests.TestType.METRICS_VIA_METER_REGISTRY ? this.clientInstrumentedWithMetrics() : this.clientInstrumentedWithObservations();
        return this.createdClient;
    }

    @Override
    protected String timerName() {
        return "http.client.requests";
    }

    protected abstract void sendHttpRequest(CLIENT var1, HttpMethod var2, @Nullable byte[] var3, URI var4, String var5, String ... var6);

    protected String substitutePathVariables(String templatedPath, String ... pathVariables) {
        if (pathVariables.length == 0) {
            return templatedPath;
        }
        String substituted = templatedPath;
        for (String substitution : pathVariables) {
            substituted = substituted.replaceFirst("\\{.*?}", substitution);
        }
        return substituted;
    }

    @ParameterizedTest
    @EnumSource
    void getTemplatedPathForUri(InstrumentationVerificationTests.TestType testType, WireMockRuntimeInfo wmRuntimeInfo) {
        this.checkAndSetupTestForTestType(testType);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
        String templatedPath = "/customers/{customerId}/carts/{cartId}";
        this.sendHttpRequest(this.instrumentedClient(testType), HttpMethod.GET, null, URI.create(wmRuntimeInfo.getHttpBaseUrl()), templatedPath, "112", "5");
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "GET", "status", "200", "outcome", "SUCCESS", "uri", templatedPath}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    @ParameterizedTest
    @EnumSource
    @Disabled(value="apache/jetty http client instrumentation currently fails this test")
    void timedWhenServerIsMissing(InstrumentationVerificationTests.TestType testType) throws IOException {
        this.checkAndSetupTestForTestType(testType);
        int unusedPort = 0;
        try (ServerSocket server2 = new ServerSocket(0);){
            unusedPort = server2.getLocalPort();
        }
        try {
            this.sendHttpRequest(this.instrumentedClient(testType), HttpMethod.GET, null, URI.create("http://localhost:" + unusedPort), "/anything", new String[0]);
        }
        catch (Throwable server2) {
            // empty catch block
        }
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "GET"}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    @ParameterizedTest
    @EnumSource
    void serverException(InstrumentationVerificationTests.TestType testType, WireMockRuntimeInfo wmRuntimeInfo) {
        this.checkAndSetupTestForTestType(testType);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.serverError()));
        this.sendHttpRequest(this.instrumentedClient(testType), HttpMethod.GET, null, URI.create(wmRuntimeInfo.getHttpBaseUrl()), "/socks", new String[0]);
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "GET", "status", "500", "outcome", "SERVER_ERROR"}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    @ParameterizedTest
    @EnumSource
    void clientException(InstrumentationVerificationTests.TestType testType, WireMockRuntimeInfo wmRuntimeInfo) {
        this.checkAndSetupTestForTestType(testType);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.badRequest()));
        this.sendHttpRequest(this.instrumentedClient(testType), HttpMethod.POST, new byte[0], URI.create(wmRuntimeInfo.getHttpBaseUrl()), "/socks", new String[0]);
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "POST", "status", "400", "outcome", "CLIENT_ERROR"}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    @ParameterizedTest
    @EnumSource
    void templatedPathWith404Response(InstrumentationVerificationTests.TestType testType, WireMockRuntimeInfo wmRuntimeInfo) {
        this.checkAndSetupTestForTestType(testType);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.notFound()));
        String templatedPath = "/fxrates/{currencypair}";
        this.sendHttpRequest(this.instrumentedClient(testType), HttpMethod.POST, new byte[0], URI.create(wmRuntimeInfo.getHttpBaseUrl()), templatedPath, "NANA");
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "POST", "status", "404", "outcome", "CLIENT_ERROR", "uri", templatedPath}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    @ParameterizedTest
    @EnumSource
    void headerIsPropagatedFromContext(InstrumentationVerificationTests.TestType testType, WireMockRuntimeInfo wmRuntimeInfo) {
        this.checkAndSetupTestForTestType(testType);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
        String templatedPath = "/fxrates/{currencypair}";
        this.sendHttpRequest(this.instrumentedClient(testType), HttpMethod.GET, null, URI.create(wmRuntimeInfo.getHttpBaseUrl()), templatedPath, "USDJPY");
        Assumptions.assumeTrue((testType == InstrumentationVerificationTests.TestType.METRICS_VIA_OBSERVATIONS_WITH_METRICS_HANDLER ? 1 : 0) != 0);
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/fxrates/USDJPY")).withHeader("Test-Propagation", WireMock.equalTo((String)"testValue")));
    }

    @Override
    protected TestObservationRegistry createObservationRegistryWithMetrics() {
        TestObservationRegistry observationRegistryWithMetrics = super.createObservationRegistryWithMetrics();
        observationRegistryWithMetrics.observationConfig().observationHandler(new SenderPropagationHandler());
        return observationRegistryWithMetrics;
    }

    private void checkAndSetupTestForTestType(InstrumentationVerificationTests.TestType testType) {
        if (testType == InstrumentationVerificationTests.TestType.METRICS_VIA_OBSERVATIONS_WITH_METRICS_HANDLER) {
            Assumptions.assumeTrue((this.clientInstrumentedWithObservations() != null ? 1 : 0) != 0, (String)"You must implement the <clientInstrumentedWithObservations> method to test your instrumentation against an ObservationRegistry");
        }
    }

    public static enum HttpMethod {
        GET,
        POST;

    }

    static class SenderPropagationHandler<T extends RequestReplySenderContext>
    implements ObservationHandler<T> {
        SenderPropagationHandler() {
        }

        public void onStart(T context) {
            context.getSetter().set(context.getCarrier(), "Test-Propagation", "testValue");
        }

        public boolean supportsContext(Observation.Context context) {
            return context instanceof RequestReplySenderContext;
        }
    }
}

