/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

interface DistributionSummaryTest {
    public Duration step();

    @Test
    @DisplayName(value="multiple recordings are maintained")
    default public void record(MeterRegistry registry) {
        DistributionSummary ds = registry.summary("my.summary", new String[0]);
        ds.record(10.0);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        ds.count();
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)ds.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)ds.totalAmount())});
        ds.record(10.0);
        ds.record(10.0);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertTrue((ds.count() >= 2L ? 1 : 0) != 0), () -> org.junit.jupiter.api.Assertions.assertTrue((ds.totalAmount() >= 20.0 ? 1 : 0) != 0)});
    }

    @Test
    @DisplayName(value="negative quantities are ignored")
    default public void recordNegative(MeterRegistry registry) {
        DistributionSummary ds = registry.summary("my.summary", new String[0]);
        ds.record(-10.0);
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)ds.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)ds.totalAmount())});
    }

    @Test
    @DisplayName(value="record zero")
    default public void recordZero(MeterRegistry registry) {
        DistributionSummary ds = registry.summary("my.summary", new String[0]);
        ds.record(0.0);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)ds.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)ds.totalAmount())});
    }

    @Test
    @DisplayName(value="scale samples by a fixed factor")
    default public void scale(MeterRegistry registry) {
        DistributionSummary ds = DistributionSummary.builder((String)"my.summary").scale(2.0).register(registry);
        ds.record(1.0);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        Assertions.assertThat((double)ds.totalAmount()).isEqualTo(2.0);
    }

    @Deprecated
    @Test
    default public void percentiles(MeterRegistry registry) {
        DistributionSummary s = DistributionSummary.builder((String)"my.summary").publishPercentiles(new double[]{1.0}).register(registry);
        s.record(1.0);
        Assertions.assertThat((double)s.percentile(1.0)).isEqualTo(1.0, Offset.offset((Number)0.3));
        Assertions.assertThat((double)s.percentile(0.5)).isNaN();
    }

    @Deprecated
    @Test
    default public void histogramCounts(MeterRegistry registry) {
        DistributionSummary s = DistributionSummary.builder((String)"my.summmary").serviceLevelObjectives(new double[]{1.0}).register(registry);
        s.record(1.0);
        Assertions.assertThat((double)s.histogramCountAtValue(1L)).isEqualTo(1.0);
        Assertions.assertThat((double)s.histogramCountAtValue(2L)).isNaN();
    }
}

