/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

interface GaugeTest {
    @Test
    @DisplayName(value="gauges attached to a number are updated when their values are observed")
    default public void numericGauge(MeterRegistry registry) {
        AtomicInteger n = (AtomicInteger)registry.gauge("my.gauge", (Number)new AtomicInteger());
        n.set(1);
        Gauge g = registry.get("my.gauge").gauge();
        Assertions.assertThat((double)g.value()).isEqualTo(1.0);
        n.set(2);
        Assertions.assertThat((double)g.value()).isEqualTo(2.0);
    }

    @Test
    @DisplayName(value="gauges attached to an object are updated when their values are observed")
    default public void objectGauge(MeterRegistry registry) {
        List list = (List)registry.gauge("my.gauge", Collections.emptyList(), new ArrayList(), List::size);
        list.addAll(Arrays.asList("a", "b"));
        Gauge g = registry.get("my.gauge").gauge();
        Assertions.assertThat((double)g.value()).isEqualTo(2.0);
    }

    @Test
    @DisplayName(value="gauges can be directly associated with collection size")
    default public void collectionSizeGauge(MeterRegistry registry) {
        List list = (List)registry.gaugeCollectionSize("my.gauge", Collections.emptyList(), new ArrayList());
        list.addAll(Arrays.asList("a", "b"));
        Gauge g = registry.get("my.gauge").gauge();
        Assertions.assertThat((double)g.value()).isEqualTo(2.0);
    }

    @Test
    @DisplayName(value="gauges can be directly associated with map entry size")
    default public void mapSizeGauge(MeterRegistry registry) {
        Map map = registry.gaugeMapSize("my.gauge", Collections.emptyList(), new HashMap());
        map.put("a", 1);
        Gauge g = registry.get("my.gauge").gauge();
        Assertions.assertThat((double)g.value()).isEqualTo(1.0);
    }

    @Test
    @DisplayName(value="gauges that reference an object that is garbage collected report NaN")
    default public void garbageCollectedSourceObject(MeterRegistry registry) {
        registry.gauge("my.gauge", Collections.emptyList(), (Object)null, Map::size);
        Assertions.assertThat((double)registry.get("my.gauge").gauge().value()).matches(val -> val == null || Double.isNaN(val) || val == 0.0);
    }

    @Test
    @DisplayName(value="strong reference gauges")
    default public void strongReferenceGauges(MeterRegistry registry) {
        Gauge.builder((String)"weak.ref", (Object)1.0, n -> n).register(registry);
        Gauge.builder((String)"strong.ref", (Object)1.0, n -> n).strongReference(true).register(registry);
        System.gc();
        Assertions.assertThat((double)registry.get("weak.ref").gauge().value()).isNaN();
        Assertions.assertThat((double)registry.get("strong.ref").gauge().value()).isEqualTo(1.0);
    }
}

