/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

interface TimerTest {
    public Duration step();

    @DisplayName(value="autocloseable sample")
    @ParameterizedTest(name="when outcome is '{0}'")
    @CsvSource(value={"success", "error"})
    default public void closeable(String outcome) {
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        try (Timer.ResourceSample sample = (Timer.ResourceSample)((Timer.ResourceSample)Timer.resource((MeterRegistry)registry, (String)"requests").description("This is an operation")).publishPercentileHistogram();){
            try {
                if (outcome.equals("error")) {
                    throw new IllegalArgumentException("boom");
                }
                sample.tag("outcome", "success");
            }
            catch (Throwable t) {
                sample.tag("outcome", "error");
            }
        }
        Assertions.assertThat((long)registry.get("requests").tag("outcome", outcome).timer().count()).isEqualTo(1L);
    }

    @DisplayName(value="record callable")
    @Test
    default public void recordCallable() throws Exception {
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        registry.timer("timer", new String[0]).recordCallable(() -> "");
    }

    @Test
    @DisplayName(value="total time and count are preserved for a single timing")
    default public void record(MeterRegistry registry) {
        Timer t = registry.timer("myTimer", new String[0]);
        t.record(42L, TimeUnit.MILLISECONDS);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)42.0, (double)t.totalTime(TimeUnit.MILLISECONDS), (double)1.0E-12)});
    }

    @Test
    @DisplayName(value="record durations")
    default public void recordDuration(MeterRegistry registry) {
        Timer t = registry.timer("myTimer", new String[0]);
        t.record(Duration.ofMillis(42L));
        MockClock.clock((MeterRegistry)registry).add(this.step());
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)42.0, (double)t.totalTime(TimeUnit.MILLISECONDS), (double)1.0E-12)});
    }

    @Test
    @DisplayName(value="negative times are discarded by the Timer")
    default public void recordNegative(MeterRegistry registry) {
        Timer t = registry.timer("myTimer", new String[0]);
        t.record(-42L, TimeUnit.MILLISECONDS);
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
    }

    @Test
    @DisplayName(value="zero times contribute to the count of overall events but do not add to total time")
    default public void recordZero(MeterRegistry registry) {
        Timer t = registry.timer("myTimer", new String[0]);
        t.record(0L, TimeUnit.MILLISECONDS);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)t.totalTime(TimeUnit.NANOSECONDS))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="record a runnable task")
    default public void recordWithRunnable(MeterRegistry registry) {
        Timer t = registry.timer("myTimer", new String[0]);
        Runnable r = () -> MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
        try {
            t.record(r);
            MockClock.clock((MeterRegistry)registry).add(this.step());
        }
        catch (Throwable throwable) {
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
            throw throwable;
        }
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="record supplier")
    default public void recordWithSupplier(MeterRegistry registry) {
        Timer t = registry.timer("myTimer", new String[0]);
        String expectedResult = "response";
        Supplier<String> supplier = () -> {
            MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
            return expectedResult;
        };
        try {
            String supplierResult = (String)t.record(supplier);
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)supplierResult);
            MockClock.clock((MeterRegistry)registry).add(this.step());
        }
        catch (Throwable throwable) {
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
            throw throwable;
        }
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="wrap supplier")
    default public void wrapSupplier(MeterRegistry registry) {
        Timer timer = registry.timer("myTimer", new String[0]);
        String expectedResult = "response";
        Supplier<String> supplier = () -> {
            MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
            return expectedResult;
        };
        try {
            Supplier wrappedSupplier = timer.wrap(supplier);
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, wrappedSupplier.get());
            MockClock.clock((MeterRegistry)registry).add(this.step());
        }
        catch (Throwable throwable) {
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)timer.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)timer.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
            throw throwable;
        }
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)timer.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)timer.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
    }

    @Test
    @DisplayName(value="record with stateful Sample instance")
    default public void recordWithSample(MeterRegistry registry) {
        Timer timer = registry.timer("myTimer", new String[0]);
        Timer.Sample sample = Timer.start((MeterRegistry)registry);
        MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
        sample.stop(timer);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)timer.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)timer.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
    }

    @Test
    default public void recordMax(MeterRegistry registry) {
        Timer timer = registry.timer("my.timer", new String[0]);
        timer.record(10L, TimeUnit.MILLISECONDS);
        timer.record(1L, TimeUnit.SECONDS);
        MockClock.clock((MeterRegistry)registry).add(this.step());
        Assertions.assertThat((double)timer.max(TimeUnit.SECONDS)).isEqualTo(1.0);
        Assertions.assertThat((double)timer.max(TimeUnit.MILLISECONDS)).isEqualTo(1000.0);
        MockClock.clock((MeterRegistry)registry).add(Duration.ofMillis(this.step().toMillis() * (long)DistributionStatisticConfig.DEFAULT.getBufferLength().intValue()));
        Assertions.assertThat((double)timer.max(TimeUnit.SECONDS)).isEqualTo(0.0);
    }

    @Test
    @DisplayName(value="callable task that throws exception is still recorded")
    default public void recordCallableException(MeterRegistry registry) {
        Timer t = registry.timer("myTimer", new String[0]);
        org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> t.recordCallable(() -> {
            MockClock.clock((MeterRegistry)registry).add(10L, TimeUnit.NANOSECONDS);
            throw new Exception("uh oh");
        }));
        MockClock.clock((MeterRegistry)registry).add(this.step());
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)t.count()), () -> org.junit.jupiter.api.Assertions.assertEquals((double)10.0, (double)t.totalTime(TimeUnit.NANOSECONDS), (double)1.0E-12)});
    }

    @Deprecated
    @Test
    default public void percentiles(MeterRegistry registry) {
        Timer t = Timer.builder((String)"my.timer").publishPercentiles(new double[]{1.0}).register(registry);
        t.record(1L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((double)t.percentile(1.0, TimeUnit.MILLISECONDS)).isEqualTo(1.0, Offset.offset((Number)0.3));
        Assertions.assertThat((double)t.percentile(0.5, TimeUnit.MILLISECONDS)).isNaN();
    }

    @Deprecated
    @Test
    default public void histogramCounts(MeterRegistry registry) {
        Timer t = Timer.builder((String)"my.timer").serviceLevelObjectives(new Duration[]{Duration.ofMillis(1L)}).register(registry);
        t.record(1L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((double)t.histogramCountAtValue((long)TimeUtils.millisToUnit((double)1.0, (TimeUnit)TimeUnit.NANOSECONDS))).isEqualTo(1.0);
        Assertions.assertThat((double)t.histogramCountAtValue(1L)).isNaN();
    }
}

