/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.InstrumentationVerificationTests;
import io.micrometer.core.instrument.search.RequiredSearch;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import java.net.URI;
import java.time.Duration;
import java.util.function.Function;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@Incubating(since="1.8.9")
public abstract class HttpServerTimingInstrumentationVerificationTests
extends InstrumentationVerificationTests {
    private final HttpSender sender = new HttpUrlConnectionSender();
    private URI baseUri;

    protected String timerName() {
        return "http.server.requests";
    }

    protected abstract URI startInstrumentedServer() throws Exception;

    protected abstract void stopInstrumentedServer() throws Exception;

    @BeforeEach
    void beforeEach() throws Exception {
        this.baseUri = this.startInstrumentedServer();
    }

    @AfterEach
    void afterEach() throws Exception {
        this.stopInstrumentedServer();
    }

    @Test
    void uriIsNotFound_whenRouteIsUnmapped() throws Throwable {
        this.sender.get(this.baseUri + "notFound").send();
        this.checkTimer(rs -> rs.tags(new String[]{"uri", "NOT_FOUND", "status", "404", "method", "GET"}).timer().count() == 1L);
    }

    @Test
    void uriTemplateIsTagged() throws Throwable {
        this.sender.get(this.baseUri + "hello/world").send();
        this.checkTimer(rs -> rs.tags(new String[]{"uri", "/hello/{name}", "status", "200", "method", "GET"}).timer().count() == 1L);
    }

    @Test
    void redirect() throws Throwable {
        this.sender.get(this.baseUri + "foundRedirect").send();
        this.checkTimer(rs -> rs.tags(new String[]{"uri", "/foundRedirect", "status", "302", "method", "GET"}).timer().count() == 1L);
    }

    @Test
    void errorResponse() throws Throwable {
        this.sender.post(this.baseUri + "error").send();
        this.checkTimer(rs -> rs.tags(new String[]{"uri", "/error", "status", "500", "method", "POST"}).timer().count() == 1L);
    }

    private void checkTimer(Function<RequiredSearch, Boolean> timerCheck) {
        Awaitility.await().atLeast(Duration.ofMillis(25L)).atMost(Duration.ofMillis(150L)).until(() -> (Boolean)timerCheck.apply(this.getRegistry().get(this.timerName())));
    }

    public static class InstrumentedRoutes {
        public static final String TEMPLATED_ROUTE = "/hello/{name}";
        public static final String ROOT = "/";
        public static final String ERROR = "/error";
        public static final String REDIRECT = "/foundRedirect";
    }
}

